/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.fast;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.rapidoid.commons.MediaType;
import org.rapidoid.config.Conf;
import org.rapidoid.crypto.Crypto;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.fast.HttpHeaders;
import org.rapidoid.http.fast.HttpMetadata;
import org.rapidoid.io.Res;
import org.rapidoid.u.U;
import org.rapidoid.util.UTILS;

public class HttpUtils
implements HttpMetadata {
    private static final String PAGE_RELOAD = "<h2>&nbsp;Reloading...</h2><script>location.reload();</script>";
    private static final byte[] EMPTY_RESPONSE = new byte[0];

    public static String[] pathSegments(Req req) {
        return U.triml((String)req.path(), (String)"/").split("/");
    }

    public static Map<String, Serializable> initAndDeserializeCookiePack(Req req) {
        String cookiepack = req.cookie("COOKIEPACK", null);
        if (!U.isEmpty((String)cookiepack)) {
            byte[] decoded = DatatypeConverter.parseBase64Binary((String)cookiepack.replace('$', '+'));
            return (Map)UTILS.deserialize((byte[])Crypto.decrypt((byte[])decoded));
        }
        return null;
    }

    public static void saveCookipackBeforeClosingHeaders(Req req, Map<String, Serializable> cookiepack) {
        if (cookiepack != null) {
            byte[] cpack = Crypto.encrypt((byte[])UTILS.serialize(cookiepack));
            String encoded = DatatypeConverter.printBase64Binary((byte[])cpack).replace('+', '$');
            HttpUtils.setCookie(req, "COOKIEPACK", encoded, "path=/");
        }
    }

    public static boolean isGetReq(Req req) {
        return req.verb().equalsIgnoreCase("GET");
    }

    public static boolean isPostReq(Req req) {
        return req.verb().equalsIgnoreCase("POST");
    }

    public static String resName(Req req) {
        String resourceName = req.path().substring(1);
        if (resourceName.isEmpty()) {
            resourceName = "index";
        } else if (resourceName.endsWith(".html")) {
            resourceName = U.mid((String)resourceName, (int)0, (int)-5);
        }
        return resourceName;
    }

    public static String verbAndResourceName(Req req) {
        return req.verb().toUpperCase() + "/" + HttpUtils.resName(req);
    }

    public static boolean hasExtension(String name) {
        int pos = name.lastIndexOf(46);
        return pos > 0 && pos < name.length() - 1;
    }

    public static void setContentTypeForFile(Resp resp, File file) {
        U.must((boolean)file.exists());
        HttpUtils.setContentType(resp, MediaType.getByFileName((String)file.getAbsolutePath()));
    }

    public static void setContentTypeForResource(Resp resp, Res resource) {
        U.must((boolean)resource.exists());
        HttpUtils.setContentType(resp, MediaType.getByFileName((String)resource.getName()));
    }

    public static void setContentType(Resp resp, MediaType mediaType) {
        resp.contentType(mediaType);
    }

    public static void setCookie(Req req, String name, String value, String ... extras) {
        value = HttpUtils.cookieValueWithExtras(value, extras);
        req.response().cookies().put(name, value);
    }

    public static String cookieValueWithExtras(String value, String ... extras) {
        if (extras.length > 0) {
            value = value + "; " + U.join((String)"; ", (Object[])extras);
        }
        return value;
    }

    public static Res staticResource(String filename, String ... possibleLocations) {
        return Res.from((String)filename, (String[])possibleLocations);
    }

    public static Res staticPage(Req req, String ... possibleLocations) {
        String resName = HttpUtils.resName(req);
        if (HttpUtils.hasExtension(resName)) {
            return HttpUtils.staticResource(resName, possibleLocations);
        }
        Res res = Res.from((String)resName, (String[])possibleLocations);
        if (!res.exists()) {
            res = Res.from((String)(resName + ".html"), (String[])possibleLocations);
        }
        return res;
    }

    public static String getErrorMessage(Throwable err) {
        Throwable cause = UTILS.rootCause((Throwable)err);
        String details = err.getClass().getSimpleName() + " (" + U.safe((String)err.getMessage()) + ")";
        if (cause instanceof SecurityException) {
            return U.frmt((String)"Access Denied: %s", (Object[])new Object[]{details});
        }
        return U.frmt((String)"Internal Server Error: %s", (Object[])new Object[]{details});
    }

    public static void postProcessResponse(Resp resp) {
        HttpUtils.postProcessRedirect(resp);
        HttpUtils.postProcessFile(resp);
        HttpUtils.postProcessFilename(resp);
    }

    private static void postProcessFile(Resp resp) {
        File file = resp.file();
        if (file != null) {
            U.must((boolean)file.exists());
            if (resp.filename() == null) {
                resp.filename();
            }
            HttpUtils.setContentTypeForFile(resp, file);
            resp.content((Object)Res.from((File)file).getBytes());
        }
    }

    private static void postProcessFilename(Resp resp) {
        String filename = resp.filename();
        if (filename != null) {
            resp.headers().put(HttpHeaders.CONTENT_DISPOSITION.name(), "attachment; filename=\"" + filename + "\"");
            resp.headers().put(HttpHeaders.CACHE_CONTROL.name(), "private");
        }
    }

    private static void postProcessRedirect(Resp resp) {
        String redirect = resp.redirect();
        if (redirect != null) {
            if (resp.code() < 300 || resp.code() >= 400) {
                resp.code(303);
            }
            resp.headers().put(HttpHeaders.LOCATION.name(), redirect);
            if (resp.content() == null && resp.body() == null) {
                resp.body(EMPTY_RESPONSE);
            }
        }
    }

    public static boolean isDevMode(Req x) {
        return Conf.dev();
    }

    public static final void reload(Req x) {
        Map sel = U.map((Object)"body", (Object)PAGE_RELOAD);
        x.response().json((Object)U.map((Object)"_sel_", (Object)sel));
    }

    public static String constructUrl(Req x, String path) {
        return (Conf.is((String)"https") ? "https://" : "http://") + x.host() + path;
    }
}

