/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.fast;

import org.rapidoid.data.JSON;
import org.rapidoid.http.fast.ErrorHandler;
import org.rapidoid.http.fast.HttpWrapper;
import org.rapidoid.http.fast.OnAction;
import org.rapidoid.http.fast.OnPage;
import org.rapidoid.http.fast.ReqHandler;
import org.rapidoid.http.fast.ReqRespHandler;
import org.rapidoid.http.fast.ServerSetup;
import org.rapidoid.http.fast.ViewRenderer;
import org.rapidoid.http.fast.handler.FastHttpHandler;
import org.rapidoid.http.fast.listener.FastHttpListener;
import org.rapidoid.job.Jobs;

public class On {
    private static final ServerSetup DEFAULT_SERVER_SETUP = new ServerSetup();
    private static boolean initialized = false;

    private static ServerSetup setup() {
        if (!initialized) {
            On.initialize();
            initialized = true;
        }
        return DEFAULT_SERVER_SETUP;
    }

    private static void initialize() {
        DEFAULT_SERVER_SETUP.listen();
        Jobs.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                JSON.warmup();
            }
        });
    }

    public static synchronized OnAction get(String path) {
        return On.setup().get(path);
    }

    public static synchronized OnAction post(String path) {
        return On.setup().post(path);
    }

    public static synchronized OnAction put(String path) {
        return On.setup().put(path);
    }

    public static synchronized OnAction delete(String path) {
        return On.setup().delete(path);
    }

    public static synchronized OnAction patch(String path) {
        return On.setup().patch(path);
    }

    public static synchronized OnAction options(String path) {
        return On.setup().options(path);
    }

    public static synchronized OnAction head(String path) {
        return On.setup().head(path);
    }

    public static synchronized OnAction trace(String path) {
        return On.setup().trace(path);
    }

    public static synchronized OnPage page(String path) {
        return On.setup().page(path);
    }

    public static synchronized ServerSetup error(ErrorHandler onError) {
        return On.setup().onError(onError);
    }

    public static synchronized ServerSetup req(ReqHandler handler) {
        return On.setup().req(handler);
    }

    public static synchronized ServerSetup req(ReqRespHandler handler) {
        return On.setup().req(handler);
    }

    public static synchronized ServerSetup req(FastHttpHandler handler) {
        return On.setup().req(handler);
    }

    public static synchronized ServerSetup req(Object ... controllers) {
        return On.setup().req(controllers);
    }

    public static synchronized ServerSetup port(int port) {
        return DEFAULT_SERVER_SETUP.port(port);
    }

    public static synchronized ServerSetup address(String address) {
        return DEFAULT_SERVER_SETUP.address(address);
    }

    public static synchronized ServerSetup defaultWrap(HttpWrapper ... wrappers) {
        return DEFAULT_SERVER_SETUP.defaultWrap(wrappers);
    }

    public static synchronized ServerSetup listener(FastHttpListener listener) {
        return DEFAULT_SERVER_SETUP.listener(listener);
    }

    public static synchronized ServerSetup getDefaultSetup() {
        return On.setup();
    }

    public static ServerSetup createCustomSetup() {
        return new ServerSetup();
    }

    public static synchronized ServerSetup staticFilesLookIn(String ... possibleLocations) {
        return On.setup().staticFilesPath(possibleLocations);
    }

    public static synchronized ServerSetup render(ViewRenderer renderer) {
        return On.setup().render(renderer);
    }
}

