/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.fast;

import java.util.concurrent.Callable;
import org.rapidoid.commons.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.fast.FastHttp;
import org.rapidoid.http.fast.HttpWrapper;
import org.rapidoid.http.fast.ReqHandler;
import org.rapidoid.http.fast.ReqRespHandler;
import org.rapidoid.http.fast.ServerSetup;
import org.rapidoid.http.fast.handler.DelegatingFastParamsAwareReqHandler;
import org.rapidoid.http.fast.handler.DelegatingFastParamsAwareReqRespHandler;
import org.rapidoid.http.fast.handler.FastCallableHttpHandler;
import org.rapidoid.http.fast.handler.FastResourceHttpHandler;
import org.rapidoid.http.fast.handler.FastStaticHttpHandler;
import org.rapidoid.http.fast.handler.HttpHandlers;
import org.rapidoid.http.fast.handler.PojoHandler;
import org.rapidoid.io.Res;
import org.rapidoid.lambda.F2;
import org.rapidoid.lambda.F3;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.pojo.POJO;
import org.rapidoid.pojo.PojoDispatcher;

public class OnAction {
    private final ServerSetup chain;
    private final FastHttp[] httpImpls;
    private final String verb;
    private final String path;
    private volatile HttpWrapper[] wrappers;

    public OnAction(ServerSetup chain, FastHttp[] httpImpls, String verb, String path) {
        this.chain = chain;
        this.httpImpls = httpImpls;
        this.verb = verb;
        this.path = path;
    }

    public OnAction wrap(HttpWrapper ... wrappers) {
        this.wrappers = wrappers;
        return this;
    }

    private void register(MediaType contentType, byte[] response) {
        for (FastHttp http : this.httpImpls) {
            http.on(this.verb, this.path, new FastStaticHttpHandler(http, contentType, response));
        }
    }

    private void register(MediaType contentType, final Object response) {
        this.register(contentType, new ReqHandler(){

            @Override
            public Object handle(Req req) throws Exception {
                return response;
            }
        });
    }

    private void register(MediaType contentType, Callable<?> handler) {
        for (FastHttp http : this.httpImpls) {
            http.on(this.verb, this.path, new FastCallableHttpHandler(http, contentType, this.wrappers, handler));
        }
    }

    private void register(MediaType contentType, ReqHandler handler) {
        for (FastHttp http : this.httpImpls) {
            http.on(this.verb, this.path, new DelegatingFastParamsAwareReqHandler(http, contentType, this.wrappers, handler));
        }
    }

    private void register(MediaType contentType, ReqRespHandler handler) {
        for (FastHttp http : this.httpImpls) {
            http.on(this.verb, this.path, new DelegatingFastParamsAwareReqRespHandler(http, contentType, this.wrappers, handler));
        }
    }

    private void register(MediaType contentType, Res resource) {
        for (FastHttp http : this.httpImpls) {
            http.on(this.verb, this.path, new FastResourceHttpHandler(http, contentType, resource));
        }
    }

    private void register(MediaType contentType, PojoDispatcher dispatcher) {
        for (FastHttp http : this.httpImpls) {
            http.on(this.verb, this.path, new PojoHandler(http, dispatcher));
        }
    }

    public ServerSetup plain(String response) {
        this.plain(response.getBytes());
        return this.chain;
    }

    public ServerSetup plain(byte[] response) {
        this.register(MediaType.PLAIN_TEXT_UTF_8, response);
        return this.chain;
    }

    public ServerSetup plain(Object response) {
        this.register(MediaType.PLAIN_TEXT_UTF_8, response);
        return this.chain;
    }

    public <T> ServerSetup plain(Callable<T> handler) {
        this.register(MediaType.PLAIN_TEXT_UTF_8, handler);
        return this.chain;
    }

    public <T> ServerSetup plain(ReqHandler handler) {
        this.register(MediaType.PLAIN_TEXT_UTF_8, handler);
        return this.chain;
    }

    public <T> ServerSetup plain(ReqRespHandler handler) {
        this.register(MediaType.PLAIN_TEXT_UTF_8, handler);
        return this.chain;
    }

    public <T> ServerSetup plain(Res resource) {
        this.register(MediaType.PLAIN_TEXT_UTF_8, resource);
        return this.chain;
    }

    public ServerSetup html(String response) {
        this.html(response.getBytes());
        return this.chain;
    }

    public ServerSetup html(byte[] response) {
        this.register(MediaType.HTML_UTF_8, response);
        return this.chain;
    }

    public ServerSetup html(Object response) {
        this.register(MediaType.HTML_UTF_8, response);
        return this.chain;
    }

    public <T> ServerSetup html(Callable<T> handler) {
        this.register(MediaType.HTML_UTF_8, handler);
        return this.chain;
    }

    public <T> ServerSetup html(ReqHandler handler) {
        this.register(MediaType.HTML_UTF_8, handler);
        return this.chain;
    }

    public <T> ServerSetup html(ReqRespHandler handler) {
        this.register(MediaType.HTML_UTF_8, handler);
        return this.chain;
    }

    public <T> ServerSetup html(Res resource) {
        this.register(MediaType.HTML_UTF_8, resource);
        return this.chain;
    }

    public ServerSetup json(String response) {
        this.json(response.getBytes());
        return this.chain;
    }

    public ServerSetup json(byte[] response) {
        this.register(MediaType.JSON_UTF_8, response);
        return this.chain;
    }

    public ServerSetup json(Object response) {
        this.register(MediaType.JSON_UTF_8, response);
        return this.chain;
    }

    public <T> ServerSetup json(Callable<T> handler) {
        this.register(MediaType.JSON_UTF_8, handler);
        return this.chain;
    }

    public <T> ServerSetup json(ReqHandler handler) {
        this.register(MediaType.JSON_UTF_8, handler);
        return this.chain;
    }

    public <T> ServerSetup json(ReqRespHandler handler) {
        this.register(MediaType.JSON_UTF_8, handler);
        return this.chain;
    }

    public <T> ServerSetup json(Res resource) {
        this.register(MediaType.JSON_UTF_8, resource);
        return this.chain;
    }

    public ServerSetup binary(String response) {
        this.binary(response.getBytes());
        return this.chain;
    }

    public ServerSetup binary(byte[] response) {
        this.register(MediaType.BINARY, response);
        return this.chain;
    }

    public ServerSetup binary(Object response) {
        this.register(MediaType.BINARY, response);
        return this.chain;
    }

    public <T> ServerSetup binary(Callable<T> handler) {
        this.register(MediaType.BINARY, handler);
        return this.chain;
    }

    public <T> ServerSetup binary(ReqHandler handler) {
        this.register(MediaType.BINARY, handler);
        return this.chain;
    }

    public <T> ServerSetup binary(ReqRespHandler handler) {
        this.register(MediaType.BINARY, handler);
        return this.chain;
    }

    public <T> ServerSetup binary(Res resource) {
        this.register(MediaType.BINARY, resource);
        return this.chain;
    }

    public ServerSetup plain(String paramName, Mapper<String, Object> handler) {
        return this.plain(HttpHandlers.parameterized(paramName, handler));
    }

    public ServerSetup plain(String paramName1, String paramName2, F2<String, String, Object> handler) {
        return this.plain(HttpHandlers.parameterized(paramName1, paramName2, handler));
    }

    public ServerSetup plain(String paramName1, String paramName2, String paramName3, F3<String, String, String, Object> handler) {
        return this.plain(HttpHandlers.parameterized(paramName1, paramName2, paramName3, handler));
    }

    public ServerSetup html(String paramName, Mapper<String, Object> handler) {
        return this.html(HttpHandlers.parameterized(paramName, handler));
    }

    public ServerSetup html(String paramName1, String paramName2, F2<String, String, Object> handler) {
        return this.html(HttpHandlers.parameterized(paramName1, paramName2, handler));
    }

    public ServerSetup html(String paramName1, String paramName2, String paramName3, F3<String, String, String, Object> handler) {
        return this.html(HttpHandlers.parameterized(paramName1, paramName2, paramName3, handler));
    }

    public ServerSetup json(String paramName, Mapper<String, Object> handler) {
        return this.json(HttpHandlers.parameterized(paramName, handler));
    }

    public ServerSetup json(String paramName1, String paramName2, F2<String, String, Object> handler) {
        return this.json(HttpHandlers.parameterized(paramName1, paramName2, handler));
    }

    public ServerSetup json(String paramName1, String paramName2, String paramName3, F3<String, String, String, Object> handler) {
        return this.json(HttpHandlers.parameterized(paramName1, paramName2, paramName3, handler));
    }

    public ServerSetup binary(String paramName, Mapper<String, Object> handler) {
        return this.binary(HttpHandlers.parameterized(paramName, handler));
    }

    public ServerSetup binary(String paramName1, String paramName2, F2<String, String, Object> handler) {
        return this.binary(HttpHandlers.parameterized(paramName1, paramName2, handler));
    }

    public ServerSetup binary(String paramName1, String paramName2, String paramName3, F3<String, String, String, Object> handler) {
        return this.binary(HttpHandlers.parameterized(paramName1, paramName2, paramName3, handler));
    }

    public ServerSetup controllers(Object ... controllers) {
        PojoDispatcher dispatcher = POJO.dispatcher((Object[])controllers);
        this.register(MediaType.HTML_UTF_8, dispatcher);
        return this.chain;
    }
}

