/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.fast;

import java.util.concurrent.Callable;
import org.rapidoid.commons.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.fast.FastHttp;
import org.rapidoid.http.fast.HttpWrapper;
import org.rapidoid.http.fast.PageOptions;
import org.rapidoid.http.fast.ReqHandler;
import org.rapidoid.http.fast.ReqRespHandler;
import org.rapidoid.http.fast.ServerSetup;
import org.rapidoid.http.fast.handler.DelegatingFastParamsAwareReqHandler;
import org.rapidoid.http.fast.handler.DelegatingFastParamsAwareReqRespHandler;
import org.rapidoid.http.fast.handler.FastResourceHttpHandler;
import org.rapidoid.http.fast.handler.FastStaticHttpHandler;
import org.rapidoid.http.fast.handler.HttpHandlers;
import org.rapidoid.io.Res;
import org.rapidoid.lambda.F2;
import org.rapidoid.lambda.F3;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;

public class OnPage {
    private final ServerSetup chain;
    private final FastHttp[] httpImpls;
    private final String path;
    private volatile HttpWrapper[] wrappers;

    public OnPage(ServerSetup chain, FastHttp[] httpImpls, String path) {
        this.chain = chain;
        this.httpImpls = httpImpls;
        this.path = path;
    }

    public OnPage wrap(HttpWrapper ... wrappers) {
        this.wrappers = wrappers;
        return this;
    }

    private void register(PageOptions options, final byte[] response) {
        if (!U.isEmpty((Object[])this.wrappers)) {
            this.register(options, new ReqHandler(){

                @Override
                public Object handle(Req req) throws Exception {
                    return response;
                }
            });
            return;
        }
        for (FastHttp http : this.httpImpls) {
            http.on("GET", this.path, new FastStaticHttpHandler(http, options.contentType, response));
            http.on("POST", this.path, new FastStaticHttpHandler(http, options.contentType, response));
        }
    }

    private void register(PageOptions options, ReqHandler handler) {
        for (FastHttp http : this.httpImpls) {
            DelegatingFastParamsAwareReqHandler hnd = new DelegatingFastParamsAwareReqHandler(http, options.contentType, this.wrappers, handler);
            http.on("GET", this.path, hnd);
            http.on("POST", this.path, hnd);
        }
    }

    private void register(PageOptions options, ReqRespHandler handler) {
        for (FastHttp http : this.httpImpls) {
            DelegatingFastParamsAwareReqRespHandler hnd = new DelegatingFastParamsAwareReqRespHandler(http, options.contentType, this.wrappers, handler);
            http.on("GET", this.path, hnd);
            http.on("POST", this.path, hnd);
        }
    }

    private void register(PageOptions options, final Res resource) {
        if (!U.isEmpty((Object[])this.wrappers)) {
            this.register(options, new ReqHandler(){

                @Override
                public Object handle(Req req) throws Exception {
                    return resource.getBytes();
                }
            });
            return;
        }
        for (FastHttp http : this.httpImpls) {
            http.on("GET", this.path, new FastResourceHttpHandler(http, options.contentType, resource));
            http.on("POST", this.path, new FastResourceHttpHandler(http, options.contentType, resource));
        }
    }

    public ServerSetup gui(String response) {
        this.gui(response.getBytes());
        return this.chain;
    }

    public ServerSetup gui(byte[] response) {
        this.register(new PageOptions(MediaType.HTML_UTF_8, false), response);
        return this.chain;
    }

    public ServerSetup gui(final Object response) {
        return this.gui(new ReqHandler(){

            @Override
            public Object handle(Req req) throws Exception {
                return response;
            }
        });
    }

    public ServerSetup gui(final Callable<?> handler) {
        return this.gui(new ReqHandler(){

            @Override
            public Object handle(Req req) throws Exception {
                return handler.call();
            }
        });
    }

    public ServerSetup gui(ReqHandler handler) {
        this.register(new PageOptions(MediaType.HTML_UTF_8, false), handler);
        return this.chain;
    }

    public ServerSetup gui(ReqRespHandler handler) {
        this.register(new PageOptions(MediaType.HTML_UTF_8, false), handler);
        return this.chain;
    }

    public ServerSetup gui(Res resource) {
        this.register(new PageOptions(MediaType.HTML_UTF_8, false), resource);
        return this.chain;
    }

    public ServerSetup gui(String paramName, Mapper<String, Object> handler) {
        return this.gui(HttpHandlers.parameterized(paramName, handler));
    }

    public ServerSetup gui(String paramName1, String paramName2, F2<String, String, Object> handler) {
        return this.gui(HttpHandlers.parameterized(paramName1, paramName2, handler));
    }

    public ServerSetup gui(String paramName1, String paramName2, String paramName3, F3<String, String, String, Object> handler) {
        return this.gui(HttpHandlers.parameterized(paramName1, paramName2, paramName3, handler));
    }
}

