/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.fast;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.rapidoid.buffer.Buf;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.MediaType;
import org.rapidoid.data.JSON;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.fast.FastHttp;
import org.rapidoid.http.fast.HttpHeaders;
import org.rapidoid.http.fast.HttpMetadata;
import org.rapidoid.http.fast.HttpUtils;
import org.rapidoid.http.fast.RespImpl;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.util.UTILS;

public class ReqImpl
implements Req,
Constants,
HttpMetadata {
    private final FastHttp http;
    private final Channel channel;
    private volatile boolean isKeepAlive;
    private volatile String verb;
    private volatile String uri;
    private volatile String path;
    private volatile String query;
    private volatile byte[] body;
    private final Map<String, String> params;
    private final Map<String, String> headers;
    private final Map<String, String> cookies;
    private final Map<String, Object> posted;
    private final Map<String, byte[]> files;
    private final Map<String, Object> attrs = Collections.synchronizedMap(new HashMap());
    private volatile Map<String, Object> data;
    private volatile Map<String, Serializable> cookiepack;
    private volatile Resp response;
    private volatile boolean rendering;
    private volatile int posConLen;
    private volatile int posBefore;
    private volatile boolean async;
    private volatile boolean done;
    private volatile boolean completed;
    private final MediaType defaultContentType;

    public ReqImpl(FastHttp http, Channel channel, boolean isKeepAlive, String verb, String uri, String path, String query, byte[] body, Map<String, String> params, Map<String, String> headers, Map<String, String> cookies, Map<String, Object> posted, Map<String, byte[]> files, MediaType defaultContentType) {
        this.http = http;
        this.channel = channel;
        this.isKeepAlive = isKeepAlive;
        this.verb = verb;
        this.uri = uri;
        this.path = path;
        this.query = query;
        this.body = body;
        this.params = params;
        this.headers = headers;
        this.cookies = cookies;
        this.posted = posted;
        this.files = files;
        this.defaultContentType = defaultContentType;
    }

    public String verb() {
        return this.verb;
    }

    public Req verb(String verb) {
        this.verb = verb;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public Req uri(String uri) {
        this.uri = uri;
        return this;
    }

    public String path() {
        return this.path;
    }

    public Req path(String path) {
        this.path = path;
        return this;
    }

    public String query() {
        return this.query;
    }

    public Req query(String query) {
        this.query = query;
        return this;
    }

    public byte[] body() {
        return this.body;
    }

    public Req body(byte[] body) {
        this.body = body;
        return this;
    }

    public Map<String, String> params() {
        return this.params;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public Map<String, String> cookies() {
        return this.cookies;
    }

    public Map<String, Object> posted() {
        return this.posted;
    }

    public Map<String, byte[]> files() {
        return this.files;
    }

    public String clientIpAddress() {
        return this.channel.address();
    }

    public String host() {
        return this.header(HttpHeaders.HOST.name());
    }

    public Req host(String host) {
        this.headers().put(HttpHeaders.HOST.name(), host);
        return this;
    }

    public long connectionId() {
        return this.channel.connId();
    }

    public long requestId() {
        return this.channel.requestId();
    }

    public String param(String name) {
        return (String)U.notNull((Object)this.params().get(name), (String)"PARAMS[%s]", (Object[])new Object[]{name});
    }

    public String param(String name, String defaultValue) {
        return this.withDefault(this.params().get(name), defaultValue);
    }

    public String header(String name) {
        return (String)U.notNull((Object)this.headers().get(name), (String)"HEADERS[%s]", (Object[])new Object[]{name});
    }

    public String header(String name, String defaultValue) {
        return (String)U.or((Object)this.headers().get(name), (Object)defaultValue);
    }

    public String cookie(String name) {
        return (String)U.notNull((Object)this.cookies().get(name), (String)"COOKIES[%s]", (Object[])new Object[]{name});
    }

    public String cookie(String name, String defaultValue) {
        return (String)U.or((Object)this.cookies().get(name), (Object)defaultValue);
    }

    public <T extends Serializable> T posted(String name) {
        return (T)((Serializable)U.notNull((Object)this.posted().get(name), (String)"POSTED[%s]", (Object[])new Object[]{name}));
    }

    public <T extends Serializable> T posted(String name, T defaultValue) {
        return this.withDefault(this.posted().get(name), defaultValue);
    }

    public byte[] file(String name) {
        return (byte[])U.notNull((Object)this.files().get(name), (String)"FILES[%s]", (Object[])new Object[]{name});
    }

    public byte[] file(String name, byte[] defaultValue) {
        return (byte[])U.or((Object)this.files().get(name), (Object)defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> data() {
        if (this.data == null) {
            ReqImpl reqImpl = this;
            synchronized (reqImpl) {
                if (this.data == null) {
                    Map allData = U.map();
                    allData.putAll(this.params);
                    allData.putAll(this.files);
                    allData.putAll(this.posted);
                    this.data = Collections.unmodifiableMap(allData);
                }
            }
        }
        return this.data;
    }

    public <T> T data(String name) {
        return (T)U.notNull(this.data(name, null), (String)"DATA[%s]", (Object[])new Object[]{name});
    }

    public <T> T data(String name, T defaultValue) {
        Object value = this.posted(name, null);
        if (value == null && (value = this.file(name, null)) == null) {
            value = this.param(name, null);
        }
        return this.withDefault(value, defaultValue);
    }

    public Map<String, Object> attrs() {
        return this.attrs;
    }

    public <T> T attr(String name) {
        return (T)U.notNull((Object)this.attrs().get(name), (String)"ATTRS[%s]", (Object[])new Object[]{name});
    }

    public <T> T attr(String name, T defaultValue) {
        return this.withDefault(this.attrs().get(name), defaultValue);
    }

    private <T> T withDefault(Object value, T defaultValue) {
        if (value != null) {
            return (T)(defaultValue != null ? Cls.convert((Object)value, (Class)Cls.of(defaultValue)) : value);
        }
        return defaultValue;
    }

    public synchronized Resp response() {
        if (this.response == null) {
            this.response = new RespImpl(this);
            if (this.defaultContentType != null) {
                this.response.contentType(this.defaultContentType);
            }
        }
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startRendering(int code) {
        if (!this.isRendering()) {
            ReqImpl reqImpl = this;
            synchronized (reqImpl) {
                if (!this.isRendering()) {
                    this.startResponse(code);
                    this.rendering = true;
                }
            }
        }
    }

    private void startResponse(int code) {
        MediaType contentType = MediaType.HTML_UTF_8;
        if (this.cookiepack != null) {
            HttpUtils.saveCookipackBeforeClosingHeaders(this, this.cookiepack);
        }
        if (this.response != null) {
            contentType = (MediaType)U.or((Object)this.response.contentType(), (Object)MediaType.HTML_UTF_8);
        }
        this.renderResponseHeaders(code, contentType);
    }

    private void renderResponseHeaders(int code, MediaType contentType) {
        this.http.startResponse(this.channel, code, this.isKeepAlive, contentType);
        if (this.response != null || !U.isEmpty(this.cookies)) {
            this.renderCustomHeaders();
        }
        Buf out = this.channel.output();
        this.channel.write(FastHttp.CONTENT_LENGTH_UNKNOWN);
        this.posConLen = out.size();
        this.channel.write(CR_LF);
        this.channel.write(CR_LF);
        this.posBefore = out.size();
    }

    private void completeResponse() {
        Buf out = this.channel.output();
        int posAfter = out.size();
        int contentLength = posAfter - this.posBefore;
        out.putNumAsText(this.posConLen, (long)contentLength, false);
        this.completed = true;
    }

    public boolean isRendering() {
        return this.rendering;
    }

    public synchronized Req done() {
        if (!this.done) {
            this.onDone();
            this.done = true;
        }
        return this;
    }

    private void onDone() {
        if (!this.rendering) {
            this.renderResponse();
        }
        if (!this.completed) {
            this.completeResponse();
            this.completed = true;
        }
        this.finish();
    }

    private void renderResponse() {
        String err = this.validateResponse();
        if (this.response != null) {
            HttpUtils.postProcessResponse(this.response);
        }
        if (err != null) {
            this.startRendering(500);
            this.http.renderBody(this.channel, 500, MediaType.HTML_UTF_8, err.getBytes());
        } else if (this.response.raw() != null) {
            byte[] bytes = UTILS.toBytes((Object)this.response.raw());
            this.channel.write(bytes);
            this.completed = true;
        } else {
            this.renderResponseBody();
        }
    }

    private void renderResponseBody() {
        byte[] bytes;
        block4: {
            try {
                if (this.response.content() != null) {
                    bytes = this.serializeResponse();
                    break block4;
                }
                if (this.response.body() != null) {
                    bytes = UTILS.toBytes((Object)this.response.body());
                    break block4;
                }
                throw U.rte((String)"There's no HTTP response body to render!");
            }
            catch (Throwable e) {
                this.http.error(this.channel, this.isKeepAlive, this, e);
                this.completed = true;
                return;
            }
        }
        this.startRendering(this.response.code());
        this.http.renderBody(this.channel, this.response.code(), this.response.contentType(), bytes);
    }

    private byte[] serializeResponse() {
        Object content = this.response.content();
        if (U.eq((Object)this.response.contentType(), (Object)MediaType.JSON_UTF_8)) {
            return JSON.stringifyToBytes((Object)content);
        }
        return UTILS.toBytes((Object)content);
    }

    private String validateResponse() {
        if (this.response == null) {
            return "Response wasn't provided!";
        }
        if (this.response.content() == null && this.response.body() == null && this.response.redirect() == null && this.response.file() == null && this.response.raw() == null) {
            return "Response content wasn't provided!";
        }
        if (this.response.contentType() == null && this.response.raw() == null) {
            return "Response content type wasn't provided!";
        }
        return null;
    }

    private void renderCustomHeaders() {
        for (Map.Entry e : this.response.headers().entrySet()) {
            this.http.addCustomHeader(this.channel, ((String)e.getKey()).getBytes(), ((String)e.getValue()).getBytes());
        }
        for (Map.Entry e : this.response.cookies().entrySet()) {
            String cookie = (String)e.getKey() + "=" + (String)e.getValue();
            this.http.addCustomHeader(this.channel, HttpHeaders.SET_COOKIE.getBytes(), cookie.getBytes());
        }
    }

    private void finish() {
        this.http.done(this.channel, this.isKeepAlive);
    }

    public boolean isDone() {
        return this.done;
    }

    public Req async() {
        this.async = true;
        return this;
    }

    public boolean isAsync() {
        return this.async;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sessionId() {
        String sessionId = this.cookie("JSESSIONID", null);
        if (U.isEmpty((String)sessionId)) {
            sessionId = UUID.randomUUID().toString();
            Map<String, String> map = this.cookies;
            synchronized (map) {
                if (this.cookie("JSESSIONID", null) == null) {
                    this.cookies.put("JSESSIONID", sessionId);
                    HttpUtils.setCookie(this, "JSESSIONID", sessionId, "path=/");
                }
            }
        }
        return sessionId;
    }

    public boolean hasSession() {
        return this.cookie("JSESSIONID", null) != null;
    }

    public Map<String, Serializable> session() {
        return this.http.session(this.sessionId());
    }

    public <T extends Serializable> T session(String name) {
        Serializable value = this.hasSession() ? this.session().get(name) : null;
        return (T)((Serializable)U.notNull((Object)value, (String)"SESSION[%s]", (Object[])new Object[]{name}));
    }

    public <T extends Serializable> T session(String name, T defaultValue) {
        Serializable value = this.hasSession() ? this.session().get(name) : null;
        return this.withDefault(value, defaultValue);
    }

    public boolean hasCookiepack() {
        return this.cookie("COOKIEPACK", null) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Serializable> cookiepack() {
        if (this.cookiepack == null) {
            ReqImpl reqImpl = this;
            synchronized (reqImpl) {
                if (this.cookiepack == null) {
                    this.cookiepack = Collections.synchronizedMap(U.safe(HttpUtils.initAndDeserializeCookiePack(this)));
                }
            }
        }
        return this.cookiepack;
    }

    public <T extends Serializable> T cookiepack(String name) {
        Serializable value = this.hasCookiepack() ? this.cookiepack().get(name) : null;
        return (T)((Serializable)U.notNull((Object)value, (String)"COOKIEPACK[%s]", (Object[])new Object[]{name}));
    }

    public <T extends Serializable> T cookiepack(String name, T defaultValue) {
        Serializable value = this.hasCookiepack() ? this.cookiepack().get(name) : null;
        return this.withDefault(value, defaultValue);
    }

    public String toString() {
        return this.verb() + " " + this.uri();
    }

    Channel channel() {
        return this.channel;
    }

    FastHttp http() {
        return this.http;
    }
}

