/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.fast;

import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.rapidoid.commons.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.fast.HttpUtils;
import org.rapidoid.http.fast.ReqImpl;
import org.rapidoid.http.fast.ViewRenderer;
import org.rapidoid.u.U;

public class RespImpl
implements Resp {
    private final ReqImpl req;
    private volatile Object content = null;
    private volatile Object body = null;
    private volatile Object raw = null;
    private volatile int code = 200;
    private volatile MediaType contentType = MediaType.HTML_UTF_8;
    private final Map<String, String> headers = Collections.synchronizedMap(new HashMap());
    private final Map<String, String> cookies = Collections.synchronizedMap(new HashMap());
    private final Map<String, Object> model = Collections.synchronizedMap(new HashMap());
    private volatile String redirect = null;
    private volatile String filename = null;
    private volatile File file = null;
    private volatile String view = null;

    public RespImpl(ReqImpl req) {
        this.req = req;
    }

    public synchronized Resp content(Object content) {
        this.ensureCanChange();
        this.content = content;
        return this;
    }

    public synchronized Object content() {
        return this.content;
    }

    public synchronized Resp body(byte[] body) {
        this.ensureCanChange();
        this.body = body;
        return this;
    }

    public synchronized Resp body(ByteBuffer body) {
        this.ensureCanChange();
        this.body = body;
        return this;
    }

    public synchronized Object body() {
        return this.body;
    }

    public synchronized Resp raw(byte[] raw) {
        this.ensureCanChange();
        this.raw = raw;
        return this;
    }

    public synchronized Resp raw(ByteBuffer raw) {
        this.ensureCanChange();
        this.raw = raw;
        return this;
    }

    public synchronized Object raw() {
        return this.raw;
    }

    public synchronized Resp code(int code) {
        this.ensureCanChange();
        this.code = code;
        return this;
    }

    public synchronized int code() {
        return this.code;
    }

    public Map<String, String> headers() {
        return this.isReadOnly() ? Collections.unmodifiableMap(this.headers) : this.headers;
    }

    public Map<String, String> cookies() {
        return this.isReadOnly() ? Collections.unmodifiableMap(this.cookies) : this.cookies;
    }

    public Map<String, Object> model() {
        return this.isReadOnly() ? Collections.unmodifiableMap(this.model) : this.model;
    }

    public synchronized Resp contentType(MediaType contentType) {
        this.ensureCanChange();
        this.contentType = contentType;
        return this;
    }

    public synchronized MediaType contentType() {
        return this.contentType;
    }

    public synchronized Resp redirect(String redirect) {
        this.ensureCanChange();
        this.redirect = redirect;
        return this;
    }

    public synchronized String redirect() {
        return this.redirect;
    }

    public synchronized Resp filename(String filename) {
        this.ensureCanChange();
        this.filename = filename;
        return this;
    }

    public synchronized String filename() {
        return this.filename;
    }

    public synchronized Resp file(File file) {
        this.ensureCanChange();
        this.file = file;
        return this;
    }

    public synchronized File file() {
        return this.file;
    }

    private void ensureCanChange() {
        U.must((!this.req.isDone() ? 1 : 0) != 0, (String)"The request was already processed, so the response can't be changed now!");
        U.must((!this.req.isRendering() ? 1 : 0) != 0, (String)"The response rendering has already started, so the response can't be changed now!");
    }

    private boolean isReadOnly() {
        return this.req.isRendering() || this.req.isDone();
    }

    public Req done() {
        return this.req.done();
    }

    public Resp html(Object content) {
        return this.contentType(MediaType.HTML_UTF_8).content(content);
    }

    public Resp plain(Object content) {
        return this.contentType(MediaType.PLAIN_TEXT_UTF_8).content(content);
    }

    public Resp json(Object content) {
        return this.contentType(MediaType.JSON_UTF_8).content(content);
    }

    public Resp binary(Object content) {
        return this.contentType(MediaType.BINARY).content(content);
    }

    public Resp render() {
        ViewRenderer renderer = this.req.http().getRenderer();
        U.must((renderer != null ? 1 : 0) != 0, (String)"A view renderer wasn't set! Please use On.render() to configure a renderer!");
        try {
            renderer.render(this.req, this);
        }
        catch (Throwable e) {
            throw U.rte((String)("Error while rendering view: " + this.view()), (Throwable)e);
        }
        return this;
    }

    public synchronized String view() {
        return this.view != null ? this.view : HttpUtils.resName(this.req);
    }

    public synchronized Resp view(String view) {
        this.view = view;
        return this;
    }

    public Req request() {
        return this.req;
    }

    public OutputStream out() {
        U.must((this.content() == null ? 1 : 0) != 0, (String)"The response content has already been set, so cannot write the response through OutputStream, too!");
        U.must((this.body() == null ? 1 : 0) != 0, (String)"The response body has already been set, so cannot write the response through OutputStream, too!");
        U.must((this.raw() == null ? 1 : 0) != 0, (String)"The raw response has already been set, so cannot write the response through OutputStream, too!");
        this.req.startRendering(this.code());
        return this.req.channel().output().asOutputStream();
    }
}

