/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.fast;

import java.util.List;
import java.util.Map;
import org.rapidoid.commons.MediaType;
import org.rapidoid.config.Conf;
import org.rapidoid.http.fast.ErrorHandler;
import org.rapidoid.http.fast.FastHttp;
import org.rapidoid.http.fast.HttpWrapper;
import org.rapidoid.http.fast.OnAction;
import org.rapidoid.http.fast.OnPage;
import org.rapidoid.http.fast.ReqHandler;
import org.rapidoid.http.fast.ReqRespHandler;
import org.rapidoid.http.fast.ViewRenderer;
import org.rapidoid.http.fast.handler.DelegatingFastParamsAwareReqHandler;
import org.rapidoid.http.fast.handler.DelegatingFastParamsAwareReqRespHandler;
import org.rapidoid.http.fast.handler.FastHttpErrorHandler;
import org.rapidoid.http.fast.handler.FastHttpHandler;
import org.rapidoid.http.fast.handler.PojoHandler;
import org.rapidoid.http.fast.listener.FastHttpListener;
import org.rapidoid.http.fast.listener.IgnorantHttpListener;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.Serve;
import org.rapidoid.net.TCPServer;
import org.rapidoid.pojo.POJO;
import org.rapidoid.pojo.PojoDispatcher;
import org.rapidoid.u.U;

public class ServerSetup {
    private volatile int port = Conf.port();
    private volatile String address = "0.0.0.0";
    private volatile FastHttpListener listener = new IgnorantHttpListener();
    private volatile HttpWrapper[] wrappers;
    private volatile FastHttp fastHttp;
    private volatile boolean listening;
    private volatile TCPServer server;

    public synchronized FastHttp http() {
        if (this.fastHttp == null) {
            this.fastHttp = new FastHttp(this.listener);
        }
        return this.fastHttp;
    }

    public synchronized TCPServer listen() {
        if (!this.listening) {
            this.listening = true;
            this.server = (TCPServer)Serve.server().protocol((Protocol)this.http()).address(this.address).port(this.port).build();
            this.server.start();
        }
        return this.server;
    }

    public OnAction get(String path) {
        return new OnAction(this, this.httpImpls(), "GET", path).wrap(this.wrappers);
    }

    public OnAction post(String path) {
        return new OnAction(this, this.httpImpls(), "POST", path).wrap(this.wrappers);
    }

    public OnAction put(String path) {
        return new OnAction(this, this.httpImpls(), "PUT", path).wrap(this.wrappers);
    }

    public OnAction delete(String path) {
        return new OnAction(this, this.httpImpls(), "DELETE", path).wrap(this.wrappers);
    }

    public OnAction patch(String path) {
        return new OnAction(this, this.httpImpls(), "PATCH", path).wrap(this.wrappers);
    }

    public OnAction options(String path) {
        return new OnAction(this, this.httpImpls(), "OPTIONS", path).wrap(this.wrappers);
    }

    public OnAction head(String path) {
        return new OnAction(this, this.httpImpls(), "HEAD", path).wrap(this.wrappers);
    }

    public OnAction trace(String path) {
        return new OnAction(this, this.httpImpls(), "TRACE", path).wrap(this.wrappers);
    }

    public OnPage page(String path) {
        return new OnPage(this, this.httpImpls(), path).wrap(this.wrappers);
    }

    public ServerSetup req(ReqHandler handler) {
        for (FastHttp http : this.httpImpls()) {
            http.addGenericHandler(new DelegatingFastParamsAwareReqHandler(http, MediaType.HTML_UTF_8, this.wrappers, handler));
        }
        return this;
    }

    public ServerSetup req(ReqRespHandler handler) {
        for (FastHttp http : this.httpImpls()) {
            http.addGenericHandler(new DelegatingFastParamsAwareReqRespHandler(http, MediaType.HTML_UTF_8, this.wrappers, handler));
        }
        return this;
    }

    public ServerSetup req(FastHttpHandler handler) {
        for (FastHttp http : this.httpImpls()) {
            http.addGenericHandler(handler);
        }
        return this;
    }

    public ServerSetup req(Object ... controllers) {
        List pojos = U.list();
        for (Object controller : controllers) {
            Object handler;
            if (controller instanceof ReqHandler) {
                handler = (ReqHandler)controller;
                this.req((ReqHandler)handler);
                continue;
            }
            if (controller instanceof ReqRespHandler) {
                handler = (ReqRespHandler)controller;
                this.req((ReqRespHandler)handler);
                continue;
            }
            if (controller instanceof FastHttpHandler) {
                handler = (FastHttpHandler)controller;
                this.req((FastHttpHandler)handler);
                continue;
            }
            pojos.add(controller);
        }
        PojoDispatcher dispatcher = POJO.dispatcher((Object[])pojos.toArray());
        for (FastHttp http : this.httpImpls()) {
            http.addGenericHandler(new PojoHandler(http, dispatcher));
        }
        return this;
    }

    public ServerSetup onError(ErrorHandler onError) {
        for (FastHttp http : this.httpImpls()) {
            http.setErrorHandler(new FastHttpErrorHandler(http, onError));
        }
        return this;
    }

    private FastHttp[] httpImpls() {
        return new FastHttp[]{this.http()};
    }

    public ServerSetup port(int port) {
        this.port = port;
        return this;
    }

    public ServerSetup address(String address) {
        this.address = address;
        return this;
    }

    public ServerSetup defaultWrap(HttpWrapper ... wrappers) {
        this.wrappers = wrappers;
        return this;
    }

    public ServerSetup listener(FastHttpListener listener) {
        U.must((this.fastHttp == null ? 1 : 0) != 0, (String)"The HTTP server was already initialized!");
        this.listener = listener;
        return this;
    }

    public ServerSetup shutdown() {
        this.reset();
        this.server.shutdown();
        this.server = null;
        return this;
    }

    public ServerSetup halt() {
        this.reset();
        this.server.halt();
        this.server = null;
        return this;
    }

    private void reset() {
        this.fastHttp.resetConfig();
        this.listening = false;
        this.fastHttp = null;
        this.wrappers = null;
    }

    public TCPServer server() {
        return this.server;
    }

    public Map<String, Object> attributes() {
        return this.http().attributes();
    }

    public ServerSetup staticFilesPath(String ... staticFilesLocations) {
        for (FastHttp http : this.httpImpls()) {
            http.setStaticFilesLocations(staticFilesLocations);
        }
        return this;
    }

    public ServerSetup render(ViewRenderer renderer) {
        for (FastHttp http : this.httpImpls()) {
            http.setRenderer(renderer);
        }
        return this;
    }
}

