/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.fast.handler;

import java.io.File;
import java.nio.ByteBuffer;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.MediaType;
import org.rapidoid.concurrent.Future;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.fast.FastHttp;
import org.rapidoid.http.fast.HttpStatus;
import org.rapidoid.http.fast.HttpWrapper;
import org.rapidoid.http.fast.handler.AbstractFastHttpHandler;
import org.rapidoid.http.fast.handler.WrappedProcess;
import org.rapidoid.io.Res;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.u.U;

public abstract class AbstractAsyncHttpHandler
extends AbstractFastHttpHandler {
    private static final String CTX_TAG_HANDLER = "handler";
    protected final HttpWrapper[] wrappers;

    public AbstractAsyncHttpHandler(FastHttp http, MediaType contentType, HttpWrapper[] wrappers) {
        super(http, contentType);
        this.wrappers = wrappers;
    }

    @Override
    public HttpStatus handle(Channel ctx, boolean isKeepAlive, Req req, Object extra) {
        try {
            ctx.async();
            this.execHandlerJob(ctx, isKeepAlive, req, extra);
        }
        catch (Throwable e) {
            this.http.error(ctx, isKeepAlive, req, e);
            return HttpStatus.ERROR;
        }
        return HttpStatus.ASYNC;
    }

    protected Object postprocessResult(Req req, Object result) throws Exception {
        if (result instanceof Req || result instanceof Resp || result instanceof HttpStatus) {
            return result;
        }
        if (result == null) {
            return result;
        }
        if (result instanceof java.util.concurrent.Future) {
            result = ((java.util.concurrent.Future)result).get();
            return this.postprocessResult(req, result);
        }
        if (result instanceof Future) {
            result = ((Future)result).get();
            return this.postprocessResult(req, result);
        }
        if (!(result instanceof byte[] || result instanceof ByteBuffer || result instanceof File || result instanceof Res || Cls.isSimple((Object)result) || U.isCollection((Object)result) || U.isMap((Object)result))) {
            result = this.render(result);
        }
        return result;
    }

    private String render(Object result) {
        U.str((Object)result);
        return U.str((Object)result);
    }

    private void execHandlerJob(final Channel channel, final boolean isKeepAlive, final Req req, final Object extra) {
        Runnable requestHandling = new Runnable(){

            @Override
            public void run() {
                Object result;
                Ctx ctx = Ctxs.ctx();
                ctx.setApp(null);
                ctx.setExchange((Object)req);
                ctx.setUser(null);
                try {
                    result = !U.isEmpty((Object[])AbstractAsyncHttpHandler.this.wrappers) ? AbstractAsyncHttpHandler.this.wrap(channel, isKeepAlive, req, 0, extra) : AbstractAsyncHttpHandler.this.handleReq(channel, isKeepAlive, req, extra);
                    result = AbstractAsyncHttpHandler.this.postprocessResult(req, result);
                }
                catch (Throwable e) {
                    result = e;
                }
                AbstractAsyncHttpHandler.this.complete(channel, isKeepAlive, req, result);
            }
        };
        Ctx ctx = Ctxs.get();
        if (ctx != null && U.eq((Object)ctx.tag(), (Object)CTX_TAG_HANDLER)) {
            requestHandling.run();
        } else {
            Ctx.executeInCtx((String)CTX_TAG_HANDLER, (Runnable)requestHandling);
        }
    }

    private Object wrap(final Channel channel, final boolean isKeepAlive, final Req req, final int index, final Object extra) throws Exception {
        HttpWrapper wrapper = this.wrappers[index];
        WrappedProcess process = new WrappedProcess(){

            @Override
            public Object invoke(Mapper<Object, Object> transformation) throws Exception {
                try {
                    int next = index + 1;
                    Object val = next < AbstractAsyncHttpHandler.this.wrappers.length ? AbstractAsyncHttpHandler.this.wrap(channel, isKeepAlive, req, next, extra) : AbstractAsyncHttpHandler.this.handleReq(channel, isKeepAlive, req, extra);
                    return transformation.map(val);
                }
                catch (Throwable e) {
                    return e;
                }
            }
        };
        this.http.getListener().entering(wrapper, req);
        Object result = wrapper.wrap(req, process);
        this.http.getListener().leaving(wrapper, this.contentType, result);
        return result;
    }

    protected abstract Object handleReq(Channel var1, boolean var2, Req var3, Object var4) throws Exception;

    public void complete(Channel ctx, boolean isKeepAlive, Req req, Object result) {
        if (result == null) {
            this.http.notFound(ctx, isKeepAlive, this, req);
            return;
        }
        if (result instanceof Throwable) {
            Throwable error = (Throwable)result;
            this.http.error(ctx, isKeepAlive, req, error);
            return;
        }
        if (result instanceof HttpStatus) {
            this.http.error(ctx, isKeepAlive, req, U.notExpected());
            return;
        }
        if (result instanceof Req) {
            U.must((req == result ? 1 : 0) != 0);
        } else if (result instanceof Resp) {
            U.must((req.response() == result ? 1 : 0) != 0);
        } else {
            req.response().content(result);
        }
        if (!req.isAsync()) {
            req.done();
        }
    }
}

