/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.fast.handler;

import org.rapidoid.commons.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.fast.FastHttp;
import org.rapidoid.http.fast.HttpStatus;
import org.rapidoid.http.fast.HttpUtils;
import org.rapidoid.http.fast.handler.AbstractFastHttpHandler;
import org.rapidoid.io.Res;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.u.U;

public class FastStaticResourcesHandler
extends AbstractFastHttpHandler {
    private final FastHttp http;

    public FastStaticResourcesHandler(FastHttp http) {
        super(http, null);
        this.http = http;
    }

    @Override
    public HttpStatus handle(Channel ctx, boolean isKeepAlive, Req req, Object extra) {
        this.http.getListener().state(this, req);
        try {
            Res res;
            byte[] bytes;
            Object[] staticFilesLocations = this.http.getStaticFilesLocations();
            if (!U.isEmpty((Object[])staticFilesLocations) && (bytes = (res = HttpUtils.staticPage(req, (String[])staticFilesLocations)).getBytesOrNull()) != null) {
                MediaType contentType = MediaType.getByFileName((String)res.getName());
                this.http.getListener().result(this, contentType, bytes);
                this.http.write200(ctx, isKeepAlive, contentType, bytes);
                return HttpStatus.DONE;
            }
            this.http.getListener().resultNotFound(this);
            return HttpStatus.NOT_FOUND;
        }
        catch (Exception e) {
            this.http.error(ctx, isKeepAlive, req, e);
            return HttpStatus.ERROR;
        }
    }

    @Override
    public boolean needsParams() {
        return true;
    }
}

