/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.fast.handler;

import java.util.Map;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.fast.FastHttp;
import org.rapidoid.http.fast.handler.FastParamsAwareHttpHandler;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.pojo.DispatchResult;
import org.rapidoid.pojo.PojoDispatchException;
import org.rapidoid.pojo.PojoDispatcher;
import org.rapidoid.pojo.PojoHandlerNotFoundException;
import org.rapidoid.pojo.PojoRequest;
import org.rapidoid.pojo.impl.DispatchReqKind;
import org.rapidoid.pojo.web.WebReq;
import org.rapidoid.u.U;
import org.rapidoid.util.UTILS;

public class PojoHandler
extends FastParamsAwareHttpHandler {
    private final PojoDispatcher dispatcher;

    public PojoHandler(FastHttp http, PojoDispatcher dispatcher) {
        super(http, null, null);
        this.dispatcher = dispatcher;
    }

    @Override
    protected Object doHandle(Channel channel, boolean isKeepAlive, Req req, Object extra) throws Exception {
        Resp resp = req.response();
        DispatchResult dispatched = this.doDispatch(this.dispatcher, (PojoRequest)new WebReq(req));
        if (dispatched != null) {
            Object result = dispatched.getResult();
            Map config = dispatched.getConfig();
            if (dispatched.getKind() == DispatchReqKind.SERVICE) {
                return resp.contentType(MediaType.JSON_UTF_8).content(result);
            }
            resp.contentType(MediaType.HTML_UTF_8);
            boolean isRaw = config != null && Cls.bool(config.get("raw"));
            return isRaw ? resp.body(UTILS.toBytes((Object)result)) : resp.content(result);
        }
        return null;
    }

    private DispatchResult doDispatch(PojoDispatcher dispatcher, PojoRequest req) {
        try {
            return dispatcher.dispatch(req);
        }
        catch (PojoHandlerNotFoundException e) {
            return null;
        }
        catch (PojoDispatchException e) {
            throw U.rte((String)"Dispatch error!", (Throwable)e);
        }
    }
}

