/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Platform;

public interface Capabilities {
    default public String getBrowserName() {
        return String.valueOf(Optional.ofNullable(this.getCapability("browserName")).orElse(""));
    }

    default public Platform getPlatform() {
        Object rawPlatform = this.getCapability("platform");
        if (rawPlatform == null) {
            return null;
        }
        if (rawPlatform instanceof String) {
            return Platform.valueOf((String)rawPlatform);
        }
        if (rawPlatform instanceof Platform) {
            return (Platform)((Object)rawPlatform);
        }
        throw new IllegalStateException("Platform was neither a string or a Platform: " + rawPlatform);
    }

    default public String getVersion() {
        return String.valueOf(Optional.ofNullable(this.getCapability("version")).orElse(""));
    }

    @Deprecated
    default public boolean isJavascriptEnabled() {
        return this.is("javascriptEnabled");
    }

    public Map<String, ?> asMap();

    public Object getCapability(String var1);

    default public boolean is(String capabilityName) {
        Object cap = this.getCapability(capabilityName);
        if (cap == null) {
            return "javascriptEnabled".equals(capabilityName);
        }
        return cap instanceof Boolean ? (Boolean)cap : Boolean.parseBoolean(String.valueOf(cap));
    }

    default public Capabilities merge(Capabilities other) {
        HashMap map = new HashMap();
        map.putAll(this.asMap());
        if (other != null) {
            map.putAll(other.asMap());
        }
        return new ImmutableCapabilities(map);
    }
}

