/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class ChromiumDevToolsLocator {
    private static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger(ChromiumDevToolsLocator.class.getName());

    public static Optional<URI> getReportedUri(String capabilityKey, Capabilities caps) {
        Object raw = caps.getCapability(capabilityKey);
        if (!(raw instanceof Map)) {
            LOG.fine("No capabilities for " + capabilityKey);
            return Optional.empty();
        }
        if (!((raw = ((Map)raw).get("debuggerAddress")) instanceof String)) {
            LOG.fine("No debugger address");
            return Optional.empty();
        }
        int index = ((String)raw).lastIndexOf(58);
        if (index == -1 || index == ((String)raw).length() - 1) {
            LOG.fine("No index in " + raw);
            return Optional.empty();
        }
        try {
            URI uri = new URI(String.format("http://%s", raw));
            LOG.fine("URI found: " + uri);
            return Optional.of(uri);
        }
        catch (URISyntaxException e) {
            LOG.warning("Unable to creeate URI from: " + raw);
            return Optional.empty();
        }
    }

    public static Optional<URI> getCdpEndPoint(HttpClient.Factory clientFactory, URI reportedUri) {
        Require.nonNull((String)"HTTP client factory", (Object)clientFactory);
        Require.nonNull((String)"DevTools URI", (Object)reportedUri);
        ClientConfig config = ClientConfig.defaultConfig().baseUri(reportedUri);
        HttpClient client = clientFactory.createClient(config);
        HttpResponse res = client.execute(new HttpRequest(HttpMethod.GET, "/json/version"));
        if (res.getStatus() != 200) {
            return Optional.empty();
        }
        Map versionData = (Map)JSON.toType(Contents.string((HttpMessage)res), Json.MAP_TYPE);
        Object raw = versionData.get("webSocketDebuggerUrl");
        if (!(raw instanceof String)) {
            return Optional.empty();
        }
        String debuggerUrl = (String)raw;
        try {
            return Optional.of(new URI(debuggerUrl));
        }
        catch (URISyntaxException e) {
            LOG.warning("Invalid URI for endpoint " + raw);
            return Optional.empty();
        }
    }

    public static Optional<Connection> getChromeConnector(HttpClient.Factory clientFactory, Capabilities caps, String capabilityKey) {
        try {
            return ChromiumDevToolsLocator.getReportedUri(capabilityKey, caps).flatMap(uri -> ChromiumDevToolsLocator.getCdpEndPoint(clientFactory, uri)).map(uri -> new Connection(clientFactory.createClient(ClientConfig.defaultConfig().baseUri(uri)), uri.toString()));
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to create CDP connection", e);
            return Optional.empty();
        }
    }
}

