/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v115.indexeddb.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v115.runtime.model.RemoteObject;
import org.openqa.selenium.json.JsonInput;

public class DataEntry {
    private final RemoteObject key;
    private final RemoteObject primaryKey;
    private final RemoteObject value;

    public DataEntry(RemoteObject key, RemoteObject primaryKey, RemoteObject value) {
        this.key = Objects.requireNonNull(key, "key is required");
        this.primaryKey = Objects.requireNonNull(primaryKey, "primaryKey is required");
        this.value = Objects.requireNonNull(value, "value is required");
    }

    public RemoteObject getKey() {
        return this.key;
    }

    public RemoteObject getPrimaryKey() {
        return this.primaryKey;
    }

    public RemoteObject getValue() {
        return this.value;
    }

    private static DataEntry fromJson(JsonInput input) {
        RemoteObject key = null;
        RemoteObject primaryKey = null;
        RemoteObject value = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "key": {
                    key = (RemoteObject)input.read(RemoteObject.class);
                    continue block10;
                }
                case "primaryKey": {
                    primaryKey = (RemoteObject)input.read(RemoteObject.class);
                    continue block10;
                }
                case "value": {
                    value = (RemoteObject)input.read(RemoteObject.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DataEntry(key, primaryKey, value);
    }
}

