/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v115.page.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v115.page.model.Frame;
import org.openqa.selenium.devtools.v115.page.model.FrameResource;
import org.openqa.selenium.json.JsonInput;

@Beta
public class FrameResourceTree {
    private final Frame frame;
    private final Optional<List<FrameResourceTree>> childFrames;
    private final List<FrameResource> resources;

    public FrameResourceTree(Frame frame, Optional<List<FrameResourceTree>> childFrames, List<FrameResource> resources) {
        this.frame = Objects.requireNonNull(frame, "frame is required");
        this.childFrames = childFrames;
        this.resources = Objects.requireNonNull(resources, "resources is required");
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Optional<List<FrameResourceTree>> getChildFrames() {
        return this.childFrames;
    }

    public List<FrameResource> getResources() {
        return this.resources;
    }

    private static FrameResourceTree fromJson(JsonInput input) {
        Frame frame = null;
        Optional<List<FrameResourceTree>> childFrames = Optional.empty();
        List resources = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frame": {
                    frame = (Frame)input.read(Frame.class);
                    continue block10;
                }
                case "childFrames": {
                    childFrames = Optional.ofNullable((List)input.read(new TypeToken<List<FrameResourceTree>>(){}.getType()));
                    continue block10;
                }
                case "resources": {
                    resources = (List)input.read(new TypeToken<List<FrameResource>>(){}.getType());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameResourceTree(frame, childFrames, resources);
    }
}

