/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edgehtml;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.edgehtml.EdgeHtmlDriver;
import org.openqa.selenium.edgehtml.EdgeHtmlDriverService;
import org.openqa.selenium.edgehtml.EdgeHtmlOptions;

public class EdgeHtmlDriverInfo
implements WebDriverInfo {
    public String getDisplayName() {
        return "EdgeHTML";
    }

    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", (Object)"MicrosoftEdge", "ms:edgeChromium", (Object)false);
    }

    public boolean isSupporting(Capabilities capabilities) {
        return ("MicrosoftEdge".equals(capabilities.getBrowserName()) || capabilities.getCapability("ms:edgeOptions") != null || capabilities.getCapability("edgeOptions") != null) && Objects.equals(capabilities.getCapability("ms:edgeChromium"), false);
    }

    public boolean isAvailable() {
        try {
            EdgeHtmlDriverService.createDefaultService();
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    public int getMaximumSimultaneousSessions() {
        return 1;
    }

    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(new EdgeHtmlDriver(new EdgeHtmlOptions().merge(capabilities)));
    }
}

