/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws;

import java.io.BufferedReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Splitter;
import org.sonar.api.internal.google.common.collect.ImmutableMap;
import org.sonar.api.server.ws.LocalConnector;
import org.sonar.api.utils.DateUtils;

public abstract class Request {
    protected static final String MSG_PARAMETER_MISSING = "The '%s' parameter is missing";

    public abstract String method();

    public BufferedReader getReader() {
        throw new UnsupportedOperationException("getReader not supported");
    }

    public abstract String getMediaType();

    public abstract boolean hasParam(String var1);

    public String mandatoryParam(String key) {
        String value = this.param(key);
        Preconditions.checkArgument(value != null && !value.isEmpty(), String.format(MSG_PARAMETER_MISSING, key));
        return value;
    }

    public boolean mandatoryParamAsBoolean(String key) {
        String s = this.mandatoryParam(key);
        return Request.parseBoolean(key, s);
    }

    public int mandatoryParamAsInt(String key) {
        String s = this.mandatoryParam(key);
        return Request.parseInt(key, s);
    }

    public long mandatoryParamAsLong(String key) {
        String s = this.mandatoryParam(key);
        return Request.parseLong(key, s);
    }

    public <E extends Enum<E>> E mandatoryParamAsEnum(String key, Class<E> enumClass) {
        return Enum.valueOf(enumClass, this.mandatoryParam(key));
    }

    public List<String> mandatoryParamAsStrings(String key) {
        List<String> values = this.paramAsStrings(key);
        Preconditions.checkArgument(values != null, String.format(MSG_PARAMETER_MISSING, key));
        return values;
    }

    public List<String> mandatoryMultiParam(String key) {
        List<String> values = this.multiParam(key);
        Preconditions.checkArgument(!values.isEmpty(), MSG_PARAMETER_MISSING, key);
        return values;
    }

    @CheckForNull
    public abstract List<String> paramAsStrings(String var1);

    public abstract Map<String, String[]> getParams();

    @CheckForNull
    public abstract String param(String var1);

    public abstract List<String> multiParam(String var1);

    @CheckForNull
    public abstract InputStream paramAsInputStream(String var1);

    @CheckForNull
    public abstract Part paramAsPart(String var1);

    public Part mandatoryParamAsPart(String key) {
        Part part = this.paramAsPart(key);
        Preconditions.checkArgument(part != null, MSG_PARAMETER_MISSING, key);
        return part;
    }

    @CheckForNull
    @Deprecated
    public String param(String key, @CheckForNull String defaultValue) {
        return StringUtils.defaultString(this.param(key), defaultValue);
    }

    @Deprecated
    public boolean paramAsBoolean(String key, boolean defaultValue) {
        String value = this.param(key);
        return value == null ? defaultValue : Request.parseBoolean(key, value);
    }

    @Deprecated
    public int paramAsInt(String key, int defaultValue) {
        String s = this.param(key);
        return s == null ? defaultValue : Request.parseInt(key, s);
    }

    @Deprecated
    public long paramAsLong(String key, long defaultValue) {
        String s = this.param(key);
        return s == null ? defaultValue : Request.parseLong(key, s);
    }

    @CheckForNull
    public Boolean paramAsBoolean(String key) {
        String value = this.param(key);
        return value == null ? null : Boolean.valueOf(Request.parseBoolean(key, value));
    }

    @CheckForNull
    public Integer paramAsInt(String key) {
        String s = this.param(key);
        return s == null ? null : Integer.valueOf(Request.parseInt(key, s));
    }

    @CheckForNull
    public Long paramAsLong(String key) {
        String s = this.param(key);
        return s == null ? null : Long.valueOf(Request.parseLong(key, s));
    }

    @CheckForNull
    public <E extends Enum<E>> E paramAsEnum(String key, Class<E> enumClass) {
        String s = this.param(key);
        return s == null ? null : (E)Enum.valueOf(enumClass, s);
    }

    @CheckForNull
    public <E extends Enum<E>> List<E> paramAsEnums(String key, Class<E> enumClass) {
        String value = this.param(key);
        if (value == null) {
            return null;
        }
        Iterable<String> values = Splitter.on(',').omitEmptyStrings().trimResults().split(value);
        ArrayList<E> result = new ArrayList<E>();
        for (String s : values) {
            result.add(Enum.valueOf(enumClass, s));
        }
        return result;
    }

    @CheckForNull
    public Date paramAsDateTime(String key) {
        String stringDate = this.param(key);
        if (stringDate == null) {
            return null;
        }
        Date date = DateUtils.parseDateTimeQuietly(stringDate);
        if (date != null) {
            return date;
        }
        date = DateUtils.parseDateQuietly(stringDate);
        Preconditions.checkArgument(date != null, "'%s' cannot be parsed as either a date or date+time", stringDate);
        return date;
    }

    @CheckForNull
    public Date paramAsDate(String key) {
        String s = this.param(key);
        if (s == null) {
            return null;
        }
        try {
            return DateUtils.parseDate(s);
        }
        catch (RuntimeException notDateException) {
            throw new IllegalArgumentException(notDateException);
        }
    }

    private static boolean parseBoolean(String key, String value) {
        if ("true".equals(value) || "yes".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value)) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Property %s is not a boolean value: %s", key, value));
    }

    private static int parseInt(String key, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException expection) {
            throw new IllegalArgumentException(String.format("The '%s' parameter cannot be parsed as an integer value: %s", key, value));
        }
    }

    private static long parseLong(String key, String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException(String.format("The '%s' parameter cannot be parsed as a long value: %s", key, value));
        }
    }

    public <T> Param<T> getParam(String key, BiFunction<Request, String, T> retrieveAndValidate) {
        String param = this.param(key);
        if (param != null) {
            return GenericParam.present(retrieveAndValidate.apply(this, key));
        }
        return AbsentParam.absent();
    }

    public StringParam getParam(String key, Consumer<String> validate) {
        String value = this.param(key);
        if (value != null) {
            validate.accept(value);
            return StringParamImpl.present(value);
        }
        return AbsentStringParam.absent();
    }

    public StringParam getParam(String key) {
        String value = this.param(key);
        if (value != null) {
            return StringParamImpl.present(value);
        }
        return AbsentStringParam.absent();
    }

    public abstract Optional<String> header(String var1);

    public Map<String, String> getHeaders() {
        return ImmutableMap.of();
    }

    public abstract LocalConnector localConnector();

    public abstract String getPath();

    private static <T> Supplier<T> checkDefaultValueSupplier(Supplier<T> defaultValueSupplier) {
        return Objects.requireNonNull(defaultValueSupplier, "default value supplier can't be null");
    }

    private static IllegalStateException createGetValueISE() {
        return new IllegalStateException("Param has no value. Use isPresent() before calling getValue()");
    }

    private static final class StringParamImpl
    implements StringParam {
        @CheckForNull
        private final String value;
        private final boolean emptyAsNull;

        private StringParamImpl(@Nullable String value, boolean emptyAsNull) {
            this.value = value;
            this.emptyAsNull = emptyAsNull;
        }

        static StringParam present(String value) {
            return new StringParamImpl(value, false);
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public String getValue() {
            if (this.emptyAsNull && this.value != null && this.value.isEmpty()) {
                return null;
            }
            return this.value;
        }

        @Override
        @CheckForNull
        public String or(Supplier<String> defaultValueSupplier) {
            Request.checkDefaultValueSupplier(defaultValueSupplier);
            if (this.emptyAsNull && this.value != null && this.value.isEmpty()) {
                return null;
            }
            return this.value;
        }

        @Override
        public StringParam emptyAsNull() {
            if (this.emptyAsNull || this.value != null && !this.value.isEmpty()) {
                return this;
            }
            return new StringParamImpl(this.value, true);
        }
    }

    private static enum AbsentStringParam implements StringParam
    {
        INSTANCE;


        protected static StringParam absent() {
            return INSTANCE;
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public String getValue() {
            throw Request.createGetValueISE();
        }

        @Override
        public String or(Supplier<String> defaultValueSupplier) {
            return (String)Request.checkDefaultValueSupplier(defaultValueSupplier).get();
        }

        @Override
        public StringParam emptyAsNull() {
            return this;
        }
    }

    public static interface StringParam
    extends Param<String> {
        public StringParam emptyAsNull();
    }

    private static final class GenericParam<T>
    implements Param<T> {
        private final T value;

        private GenericParam(T value) {
            this.value = value;
        }

        static <T> Param<T> present(T value) {
            return new GenericParam<T>(value);
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        @CheckForNull
        public T getValue() {
            return this.value;
        }

        @Override
        @CheckForNull
        public T or(Supplier<T> defaultValueSupplier) {
            Request.checkDefaultValueSupplier(defaultValueSupplier);
            return this.value;
        }
    }

    private static enum AbsentParam implements Param<Object>
    {
        INSTANCE;


        protected static <T> Param<T> absent() {
            return INSTANCE;
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public Object getValue() {
            throw Request.createGetValueISE();
        }

        @Override
        @CheckForNull
        public Object or(Supplier<Object> defaultValueSupplier) {
            return Request.checkDefaultValueSupplier(defaultValueSupplier).get();
        }
    }

    public static interface Param<T> {
        public boolean isPresent();

        @CheckForNull
        public T getValue();

        @CheckForNull
        public T or(Supplier<T> var1);
    }

    public static interface Part {
        public InputStream getInputStream();

        public String getFileName();
    }
}

