/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.AnalyserCommandLine;
import classycle.ClassAttributes;
import classycle.PackageProcessor;
import classycle.Parser;
import classycle.XMLPackageRenderer;
import classycle.XMLPackageStrongComponentRenderer;
import classycle.graph.AtomicVertex;
import classycle.graph.StrongComponent;
import classycle.graph.StrongComponentAnalyser;
import classycle.renderer.AtomicVertexRenderer;
import classycle.renderer.PlainStrongComponentRenderer;
import classycle.renderer.TemplateBasedClassRenderer;
import classycle.renderer.XMLClassRenderer;
import classycle.renderer.XMLStrongComponentRenderer;
import classycle.util.StringPattern;
import classycle.util.Text;
import classycle.util.TrueStringPattern;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Analyser {
    private static final String VERSION = "1.4";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String CSV_TEMPLATE = "{0},{1},{3},{2},{4},{5},{6},{7},{8},{9}\n";
    private final String[] _classFiles;
    private final StringPattern _pattern;
    private final StringPattern _reflectionPattern;
    private final boolean _mergeInnerClasses;
    private StrongComponentAnalyser _classAnalyser;
    private StrongComponentAnalyser _packageAnalyser;

    public Analyser(String[] stringArray) {
        this(stringArray, new TrueStringPattern(), null, false);
    }

    public Analyser(String[] stringArray, StringPattern stringPattern, StringPattern stringPattern2, boolean bl) {
        this._classFiles = stringArray;
        this._pattern = stringPattern;
        this._reflectionPattern = stringPattern2;
        this._mergeInnerClasses = bl;
    }

    public long createClassGraph() throws IOException {
        long l = System.currentTimeMillis();
        AtomicVertex[] atomicVertexArray = Parser.readClassFiles(this._classFiles, this._pattern, this._reflectionPattern, this._mergeInnerClasses);
        this._classAnalyser = new StrongComponentAnalyser(atomicVertexArray);
        return System.currentTimeMillis() - l;
    }

    public AtomicVertex[] getClassGraph() {
        if (this._classAnalyser == null) {
            try {
                this.createClassGraph();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
        }
        return this._classAnalyser.getGraph();
    }

    public int getNumberOfExternalClasses() {
        AtomicVertex[] atomicVertexArray = this.getClassGraph();
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        for (int i = 0; i < atomicVertexArray.length; ++i) {
            AtomicVertex atomicVertex = atomicVertexArray[i];
            int n2 = atomicVertex.getNumberOfOutgoingArcs();
            for (int j = 0; j < n2; ++j) {
                ClassAttributes classAttributes = (ClassAttributes)atomicVertex.getHeadVertex(j).getAttributes();
                if (classAttributes.getType() != "unknown external class" || hashSet.contains(classAttributes.getName())) continue;
                ++n;
                hashSet.add(classAttributes.getName());
            }
        }
        return n;
    }

    public long condenseClassGraph() {
        this.checkClassGraph("condenseClassGraph()");
        long l = System.currentTimeMillis();
        this._classAnalyser.getCondensedGraph();
        return System.currentTimeMillis() - l;
    }

    public StrongComponent[] getCondensedClassGraph() {
        this.checkClassGraph("getCondenseClassGraph()");
        return this._classAnalyser.getCondensedGraph();
    }

    public long calculateClassLayerMap() {
        this.checkClassGraph("calculateClassLayerMap()");
        long l = System.currentTimeMillis();
        this._classAnalyser.getLayerMap();
        return System.currentTimeMillis() - l;
    }

    public Map getClassLayerMap() {
        this.checkClassGraph("getClassLayerMap()");
        return this._classAnalyser.getLayerMap();
    }

    public long createPackageGraph() {
        this.checkClassGraph("createPackageGraph()");
        long l = System.currentTimeMillis();
        PackageProcessor packageProcessor = new PackageProcessor();
        packageProcessor.deepSearchFirst(this._classAnalyser.getGraph());
        this._packageAnalyser = new StrongComponentAnalyser(packageProcessor.getGraph());
        return System.currentTimeMillis() - l;
    }

    public void printCSV(PrintWriter printWriter) {
        StrongComponent[] strongComponentArray = this.getCondensedClassGraph();
        AtomicVertex[] atomicVertexArray = this.getClassGraph();
        Map map = this.getClassLayerMap();
        printWriter.println("class name,type,inner class,size,used by,uses internal classes,uses external classes,layer index,cycle,source");
        this.render(atomicVertexArray, strongComponentArray, map, new TemplateBasedClassRenderer(CSV_TEMPLATE), printWriter);
        printWriter.close();
    }

    public void printRaw(PrintWriter printWriter) {
        AtomicVertex[] atomicVertexArray = this.getClassGraph();
        for (int i = 0; i < atomicVertexArray.length; ++i) {
            AtomicVertex atomicVertex = atomicVertexArray[i];
            printWriter.println(atomicVertex.getAttributes());
            int n = atomicVertex.getNumberOfOutgoingArcs();
            for (int j = 0; j < n; ++j) {
                printWriter.println("    " + atomicVertex.getHeadVertex(j).getAttributes());
            }
        }
        printWriter.close();
    }

    public void printComponents(PrintWriter printWriter, int n) {
        this.checkClassGraph("printComponents()");
        StrongComponent[] strongComponentArray = this.getCondensedClassGraph();
        PlainStrongComponentRenderer plainStrongComponentRenderer = new PlainStrongComponentRenderer();
        for (int i = 0; i < strongComponentArray.length; ++i) {
            StrongComponent strongComponent = strongComponentArray[i];
            if (strongComponent.getNumberOfVertices() < n) continue;
            printWriter.println(plainStrongComponentRenderer.render(strongComponent));
        }
        printWriter.close();
    }

    private void checkClassGraph(String string) {
        if (this._classAnalyser == null) {
            throw new IllegalStateException(string + " should be invoked after createClassGraph().");
        }
    }

    public AtomicVertex[] getPackageGraph() {
        if (this._packageAnalyser == null) {
            this.createPackageGraph();
        }
        return this._packageAnalyser.getGraph();
    }

    public long condensePackageGraph() {
        this.checkPackageGraph("condensePackageGraph()");
        long l = System.currentTimeMillis();
        this._packageAnalyser.getCondensedGraph();
        return System.currentTimeMillis() - l;
    }

    public StrongComponent[] getCondensedPackageGraph() {
        this.checkPackageGraph("getCondensedPackageGraph()");
        return this._packageAnalyser.getCondensedGraph();
    }

    public long calculatePackageLayerMap() {
        this.checkPackageGraph("calculatePackageLayerMap()");
        long l = System.currentTimeMillis();
        this._packageAnalyser.getLayerMap();
        return System.currentTimeMillis() - l;
    }

    public Map getPackageLayerMap() {
        this.checkPackageGraph("getPackageLayerMap()");
        return this._packageAnalyser.getLayerMap();
    }

    public void readAndAnalyse(boolean bl) throws IOException {
        System.out.println("============= Classycle V1.4 =============");
        System.out.println("========== by Franz-Josef Elmer ==========");
        System.out.print("read class files and create class graph ... ");
        long l = this.createClassGraph();
        System.out.println("done after " + l + " ms: " + this.getClassGraph().length + " classes analysed.");
        if (!bl) {
            System.out.print("condense class graph ... ");
            l = this.condenseClassGraph();
            System.out.println("done after " + l + " ms: " + this.getCondensedClassGraph().length + " strong components found.");
            System.out.print("calculate class layer indices ... ");
            l = this.calculateClassLayerMap();
            System.out.println("done after " + l + " ms.");
        }
        System.out.print("create package graph ... ");
        l = this.createPackageGraph();
        System.out.println("done after " + l + " ms: " + this.getPackageGraph().length + " packages.");
        System.out.print("condense package graph ... ");
        l = this.condensePackageGraph();
        System.out.println("done after " + l + " ms: " + this.getCondensedPackageGraph().length + " strong components found.");
        System.out.print("calculate package layer indices ... ");
        l = this.calculatePackageLayerMap();
        System.out.println("done after " + l + " ms.");
    }

    public void printXML(String string, boolean bl, PrintWriter printWriter) {
        Map map;
        XMLStrongComponentRenderer xMLStrongComponentRenderer;
        StrongComponent[] strongComponentArray;
        this.checkPackageGraph("printXML()");
        printWriter.println("<?xml version='1.0' encoding='UTF-8'?>");
        printWriter.println("<?xml-stylesheet type='text/xsl' href='reportXMLtoHTML.xsl'?>");
        printWriter.print("<classycle title='");
        printWriter.print(Text.excapeForXML(string));
        printWriter.print("' date='");
        printWriter.print(DATE_FORMAT.format(new Date()));
        printWriter.println("'>");
        if (!bl) {
            strongComponentArray = this.getCondensedClassGraph();
            printWriter.println("  <cycles>");
            xMLStrongComponentRenderer = new XMLStrongComponentRenderer(2);
            for (int i = 0; i < strongComponentArray.length; ++i) {
                printWriter.print(xMLStrongComponentRenderer.render(strongComponentArray[i]));
            }
            printWriter.println("  </cycles>");
            printWriter.println("  <classes numberOfExternalClasses=\"" + this.getNumberOfExternalClasses() + "\">");
            AtomicVertex[] atomicVertexArray = this.getClassGraph();
            map = this.getClassLayerMap();
            this.render(atomicVertexArray, strongComponentArray, map, new XMLClassRenderer(), printWriter);
            printWriter.println("  </classes>");
        }
        strongComponentArray = this.getCondensedPackageGraph();
        printWriter.println("  <packageCycles>");
        xMLStrongComponentRenderer = new XMLPackageStrongComponentRenderer(2);
        for (int i = 0; i < strongComponentArray.length; ++i) {
            printWriter.print(xMLStrongComponentRenderer.render(strongComponentArray[i]));
        }
        printWriter.println("  </packageCycles>");
        printWriter.println("  <packages>");
        AtomicVertex[] atomicVertexArray = this.getPackageGraph();
        map = this.getPackageLayerMap();
        this.render(atomicVertexArray, strongComponentArray, map, new XMLPackageRenderer(), printWriter);
        printWriter.println("  </packages>");
        printWriter.println("</classycle>");
        printWriter.close();
    }

    private void render(AtomicVertex[] atomicVertexArray, StrongComponent[] strongComponentArray, Map map, AtomicVertexRenderer atomicVertexRenderer, PrintWriter printWriter) {
        List list = this.getTrueCycles(strongComponentArray);
        for (int i = 0; i < atomicVertexArray.length; ++i) {
            AtomicVertex atomicVertex = atomicVertexArray[i];
            Integer n = (Integer)map.get(atomicVertex);
            printWriter.print(atomicVertexRenderer.render(atomicVertex, this.getCycleFor(atomicVertex, list), n == null ? -1 : n));
        }
    }

    private List getTrueCycles(StrongComponent[] strongComponentArray) {
        ArrayList<StrongComponent> arrayList = new ArrayList<StrongComponent>();
        if (strongComponentArray != null) {
            for (int i = 0; i < strongComponentArray.length; ++i) {
                if (strongComponentArray[i].getNumberOfVertices() <= 1) continue;
                arrayList.add(strongComponentArray[i]);
            }
        }
        return arrayList;
    }

    private StrongComponent getCycleFor(AtomicVertex atomicVertex, List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            StrongComponent strongComponent = (StrongComponent)list.get(i);
            int n2 = strongComponent.getNumberOfVertices();
            for (int j = 0; j < n2; ++j) {
                if (strongComponent.getVertex(j) != atomicVertex) continue;
                return strongComponent;
            }
        }
        return null;
    }

    private void checkPackageGraph(String string) {
        if (this._packageAnalyser == null) {
            throw new IllegalStateException(string + " should be invoked after createPackageGraph().");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        AnalyserCommandLine analyserCommandLine = new AnalyserCommandLine(stringArray);
        if (!analyserCommandLine.isValid()) {
            System.out.println("Usage: java -jar classycle.jar " + analyserCommandLine.getUsage());
            System.exit(0);
        }
        Analyser analyser = new Analyser(analyserCommandLine.getClassFiles(), analyserCommandLine.getPattern(), analyserCommandLine.getReflectionPattern(), analyserCommandLine.isMergeInnerClasses());
        analyser.readAndAnalyse(analyserCommandLine.isPackagesOnly());
        if (analyserCommandLine.getXmlFile() != null) {
            analyser.printXML(analyserCommandLine.getTitle(), analyserCommandLine.isPackagesOnly(), new PrintWriter(new FileWriter(analyserCommandLine.getXmlFile())));
        }
        if (analyserCommandLine.getCsvFile() != null) {
            analyser.printCSV(new PrintWriter(new FileWriter(analyserCommandLine.getCsvFile())));
        }
        if (analyserCommandLine.isRaw()) {
            analyser.printRaw(new PrintWriter(System.out));
        }
        if (analyserCommandLine.isCycles() || analyserCommandLine.isStrong()) {
            analyser.printComponents(new PrintWriter(System.out), analyserCommandLine.isCycles() ? 2 : 1);
        }
    }
}

