/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.CommandLine;

public class AnalyserCommandLine
extends CommandLine {
    private static final String XML_FILE = "-xmlFile=";
    private static final String CSV_FILE = "-csvFile=";
    private static final String TITLE = "-title=";
    private boolean _packagesOnly;
    private boolean _raw;
    private boolean _cycles;
    private boolean _strong;
    private String _title;
    private String _xmlFile;
    private String _csvFile;

    public AnalyserCommandLine(String[] stringArray) {
        super(stringArray);
        if (this._title == null && this._classFiles.length > 0) {
            this._title = this._classFiles[0];
        }
    }

    @Override
    protected void handleOption(String string) {
        if (string.equals("-raw")) {
            this._raw = true;
        } else if (string.equals("-packagesOnly")) {
            this._packagesOnly = true;
        } else if (string.equals("-cycles")) {
            this._cycles = true;
        } else if (string.equals("-strong")) {
            this._strong = true;
        } else if (string.startsWith(TITLE)) {
            this._title = string.substring(TITLE.length());
            if (this._title.length() == 0) {
                this._valid = false;
            }
        } else if (string.startsWith(XML_FILE)) {
            this._xmlFile = string.substring(XML_FILE.length());
            if (this._xmlFile.length() == 0) {
                this._valid = false;
            }
        } else if (string.startsWith(CSV_FILE)) {
            this._csvFile = string.substring(CSV_FILE.length());
            if (this._csvFile.length() == 0) {
                this._valid = false;
            }
        } else {
            super.handleOption(string);
        }
    }

    @Override
    public String getUsage() {
        return "[-raw] [-packagesOnly] [-cycles|-strong] [-xmlFile=<file>] [-csvFile=<file>] [-title=<title>] " + super.getUsage();
    }

    public boolean isCycles() {
        return this._cycles;
    }

    public boolean isPackagesOnly() {
        return this._packagesOnly;
    }

    public boolean isRaw() {
        return this._raw;
    }

    public boolean isStrong() {
        return this._strong;
    }

    public String getCsvFile() {
        return this._csvFile;
    }

    public String getTitle() {
        return this._title;
    }

    public String getXmlFile() {
        return this._xmlFile;
    }
}

