/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.classfile.UTF8Constant;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

class ClassNameExtractor {
    private final String _constant;
    private int _index;
    private int _endIndex;
    private Set _classNames = new LinkedHashSet();
    private boolean _valid = true;

    static boolean isValid(String string) {
        boolean bl = true;
        boolean bl2 = true;
        int n = string.length();
        for (int i = 0; bl && i < n; ++i) {
            char c = string.charAt(i);
            if (bl2) {
                bl2 = false;
                bl = Character.isJavaIdentifierStart(c);
                continue;
            }
            if (c == '.') {
                bl2 = true;
                continue;
            }
            bl = Character.isJavaIdentifierPart(c);
        }
        return bl && !bl2;
    }

    ClassNameExtractor(UTF8Constant uTF8Constant) {
        this._constant = uTF8Constant.getString();
        this._endIndex = this._constant.length();
    }

    Set extract() {
        int n;
        if (this.getCurrentCharacter() == '<') {
            n = this._constant.indexOf("::", this._index);
            if (n > 0) {
                this._index = n + 2;
                this.parseTypes(false);
                if (this.getCurrentCharacter() == '>') {
                    ++this._index;
                } else {
                    this.setInvalid();
                }
            } else {
                this.setInvalid();
            }
        }
        if (this.getCurrentCharacter() == '(') {
            n = this._constant.indexOf(41, this._index);
            if (n > 0) {
                ++this._index;
                this._endIndex = n;
                this.parseTypes(false);
                this._index = n + 1;
                this._endIndex = this._constant.length();
            } else {
                this.setInvalid();
            }
        }
        if (this._valid && (n = this.parseTypes(false)) == 0) {
            this.setInvalid();
        }
        return this._valid ? this._classNames : Collections.EMPTY_SET;
    }

    private int parseTypes(boolean bl) {
        int n = 0;
        while (this._valid && !this.endOfTypes()) {
            this.parseType(bl);
            ++n;
        }
        return n;
    }

    private char getCurrentCharacter() {
        return this._index < this._endIndex ? this._constant.charAt(this._index) : (char)'\u0000';
    }

    private void setInvalid() {
        this._valid = false;
    }

    private boolean endOfTypes() {
        return this._index >= this._endIndex || this._constant.charAt(this._index) == '>';
    }

    private void parseType(boolean bl) {
        char c;
        if (bl) {
            c = this.getCurrentCharacter();
            if (c == '+') {
                ++this._index;
            } else if (c == '*') {
                ++this._index;
                return;
            }
        }
        c = '\u0000';
        while (this.getCurrentCharacter() == '[') {
            c = '\u0001';
            ++this._index;
        }
        if (c != '\u0000' && this.endOfTypes()) {
            this.setInvalid();
        } else {
            char c2 = this.getCurrentCharacter();
            ++this._index;
            if (c2 == 'L') {
                this.parseComplexType();
            } else if (c2 == 'T') {
                int n = this._constant.indexOf(59, this._index);
                if (n < 0) {
                    this.setInvalid();
                } else {
                    this._index = n + 1;
                }
            } else if ("BCDFIJSVZ".indexOf(c2) < 0) {
                this.setInvalid();
            }
        }
    }

    private void parseComplexType() {
        int n = this._constant.indexOf(60, this._index);
        int n2 = this._constant.indexOf(59, this._index);
        if (n >= 0 && n < n2) {
            this.extractClassName(n);
            this.parseTypes(true);
            this._index += 2;
        } else if (n2 > 0) {
            this.extractClassName(n2);
        } else {
            this.setInvalid();
        }
    }

    private void extractClassName(int n) {
        String string = this._constant.substring(this._index, n);
        string = string.replace('/', '.');
        this._classNames.add(string);
        this._index = n + 1;
        if (!ClassNameExtractor.isValid(string)) {
            this.setInvalid();
        }
    }
}

