/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.util.AndStringPattern;
import classycle.util.NotStringPattern;
import classycle.util.StringPattern;
import classycle.util.StringPatternSequence;
import classycle.util.TrueStringPattern;
import classycle.util.WildCardPattern;

public abstract class CommandLine {
    private static final String MERGE_INNER_CLASSES = "-mergeInnerClasses";
    private static final String INCLUDING_CLASSES = "-includingClasses=";
    private static final String EXCLUDING_CLASSES = "-excludingClasses=";
    private static final String REFLECTION_PATTERN = "-reflectionPattern=";
    private boolean _mergeInnerClasses;
    protected boolean _valid = true;
    protected StringPatternSequence _pattern = new AndStringPattern(new StringPattern[0]);
    protected StringPattern _reflectionPattern;
    protected String[] _classFiles;

    public CommandLine(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
            this.handleOption(stringArray[n]);
        }
        this._classFiles = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, this._classFiles, 0, this._classFiles.length);
        if (this._classFiles.length == 0) {
            this._valid = false;
        }
    }

    protected void handleOption(String string) {
        if (string.startsWith(MERGE_INNER_CLASSES)) {
            this._mergeInnerClasses = true;
        } else if (string.startsWith(INCLUDING_CLASSES)) {
            String string2 = string.substring(INCLUDING_CLASSES.length());
            this._pattern.appendPattern(WildCardPattern.createFromsPatterns(string2, ","));
        } else if (string.startsWith(EXCLUDING_CLASSES)) {
            String string3 = string.substring(EXCLUDING_CLASSES.length());
            StringPattern stringPattern = WildCardPattern.createFromsPatterns(string3, ",");
            this._pattern.appendPattern(new NotStringPattern(stringPattern));
        } else if (string.startsWith(REFLECTION_PATTERN)) {
            String string4 = string.substring(REFLECTION_PATTERN.length());
            this._reflectionPattern = string4.length() == 0 ? new TrueStringPattern() : WildCardPattern.createFromsPatterns(string4, ",");
        } else {
            this._valid = false;
        }
    }

    public String[] getClassFiles() {
        return this._classFiles;
    }

    public StringPattern getPattern() {
        return this._pattern;
    }

    public StringPattern getReflectionPattern() {
        return this._reflectionPattern;
    }

    public boolean isValid() {
        return this._valid;
    }

    public boolean isMergeInnerClasses() {
        return this._mergeInnerClasses;
    }

    public String getUsage() {
        return "[-mergeInnerClasses] [-includingClasses=<pattern1>,<pattern2>,...] [-excludingClasses=<pattern1>,<pattern2>,...] [-reflectionPattern=<pattern1>,<pattern2>,...] <class files, zip/jar/war/ear files, or folders>";
    }
}

