/*
 * Decompiled with CFR 0.152.
 */
package classycle.classfile;

import classycle.classfile.ClassConstant;
import classycle.classfile.DoubleConstant;
import classycle.classfile.FieldRefConstant;
import classycle.classfile.FloatConstant;
import classycle.classfile.IntConstant;
import classycle.classfile.InterfaceMethodRefConstant;
import classycle.classfile.LongConstant;
import classycle.classfile.MethodRefConstant;
import classycle.classfile.NameAndTypeConstant;
import classycle.classfile.StringConstant;
import classycle.classfile.UTF8Constant;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class Constant {
    private static final int MAGIC = -889275714;
    private static final int CONSTANT_CLASS = 7;
    private static final int CONSTANT_FIELDREF = 9;
    private static final int CONSTANT_METHODREF = 10;
    private static final int CONSTANT_INTERFACE_METHODREF = 11;
    private static final int CONSTANT_STRING = 8;
    private static final int CONSTANT_INTEGER = 3;
    private static final int CONSTANT_FLOAT = 4;
    private static final int CONSTANT_LONG = 5;
    private static final int CONSTANT_DOUBLE = 6;
    private static final int CONSTANT_NAME_AND_TYPE = 12;
    private static final int CONSTANT_UTF8 = 1;
    private Constant[] _pool;

    public static Constant[] extractConstantPool(DataInputStream dataInputStream) throws IOException {
        Constant[] constantArray = null;
        if (dataInputStream.readInt() == -889275714) {
            boolean bl;
            dataInputStream.readUnsignedShort();
            dataInputStream.readUnsignedShort();
            constantArray = new Constant[dataInputStream.readUnsignedShort()];
            for (int i = 1; i < constantArray.length; i += bl ? 2 : 1) {
                bl = false;
                Constant constant = null;
                int n = dataInputStream.readUnsignedByte();
                switch (n) {
                    case 7: {
                        constant = new ClassConstant(constantArray, dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 9: {
                        constant = new FieldRefConstant(constantArray, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 10: {
                        constant = new MethodRefConstant(constantArray, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 11: {
                        constant = new InterfaceMethodRefConstant(constantArray, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 8: {
                        constant = new StringConstant(constantArray, dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 3: {
                        constant = new IntConstant(constantArray, dataInputStream.readInt());
                        break;
                    }
                    case 4: {
                        constant = new FloatConstant(constantArray, dataInputStream.readFloat());
                        break;
                    }
                    case 5: {
                        constant = new LongConstant(constantArray, dataInputStream.readLong());
                        bl = true;
                        break;
                    }
                    case 6: {
                        constant = new DoubleConstant(constantArray, dataInputStream.readDouble());
                        bl = true;
                        break;
                    }
                    case 12: {
                        constant = new NameAndTypeConstant(constantArray, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 1: {
                        constant = new UTF8Constant(constantArray, dataInputStream.readUTF());
                    }
                }
                constantArray[i] = constant;
            }
            return constantArray;
        }
        throw new IOException("Not a class file: Magic number missing.");
    }

    public Constant(Constant[] constantArray) {
        this._pool = constantArray;
    }

    public Constant getConstant(int n) {
        return this._pool[n];
    }
}

