/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.Result;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.Statement;
import classycle.dependency.TextResult;
import classycle.graph.AtomicVertex;
import classycle.graph.NameAttributes;
import classycle.util.StringPattern;

public class CheckSetStatement
implements Statement {
    private final StringPattern _set;
    private final SetDefinitionRepository _repository;

    public CheckSetStatement(StringPattern stringPattern, SetDefinitionRepository setDefinitionRepository) {
        this._set = stringPattern;
        this._repository = setDefinitionRepository;
    }

    @Override
    public Result execute(AtomicVertex[] atomicVertexArray) {
        int n = 0;
        for (int i = 0; i < atomicVertexArray.length; ++i) {
            if (!this._set.matches(((NameAttributes)atomicVertexArray[i].getAttributes()).getName())) continue;
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer("Set ");
        stringBuffer.append(this._repository.toString(this._set));
        if (n == 0) {
            stringBuffer.append(" is empty.");
        } else if (n == 1) {
            stringBuffer.append(" has one class.");
        } else {
            stringBuffer.append(" has ").append(n).append(" classes.");
        }
        return new TextResult(new String(stringBuffer.append('\n')), n > 0);
    }

    public String toString() {
        return "check set " + this._repository.toString(this._set);
    }
}

