/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DefaultPreferenceFactory;
import classycle.dependency.Preference;
import classycle.dependency.PreferenceFactory;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.dependency.TextResult;

public class DefaultResultRenderer
extends ResultRenderer {
    private static final String SHOW = "show ";
    private static final PreferenceFactory FACTORY = new DefaultPreferenceFactory();
    private static final TextResult ONLY_SHORTEST_PATHS = new TextResult("show " + DefaultPreferenceFactory.ONLY_SHORTEST_PATHS.getKey() + '\n');
    private static final TextResult ALL_PATHS = new TextResult("show " + DefaultPreferenceFactory.ALL_PATHS.getKey() + '\n');
    private boolean _allResults;

    @Override
    public PreferenceFactory getPreferenceFactory() {
        return FACTORY;
    }

    @Override
    public void considerPreference(Preference preference) {
        if (preference == DefaultPreferenceFactory.ONLY_SHORTEST_PATHS) {
            this._shortestPaths = true;
        } else if (preference == DefaultPreferenceFactory.ALL_PATHS) {
            this._shortestPaths = false;
        } else if (preference == DefaultPreferenceFactory.ALL_RESULTS) {
            this._allResults = true;
        } else if (preference == DefaultPreferenceFactory.ONLY_FAILURES) {
            this._allResults = false;
        }
    }

    @Override
    public Result getDescriptionOfCurrentPreferences() {
        StringBuffer stringBuffer = new StringBuffer(SHOW);
        stringBuffer.append(this._shortestPaths ? DefaultPreferenceFactory.ONLY_SHORTEST_PATHS.getKey() : DefaultPreferenceFactory.ALL_PATHS.getKey()).append(' ').append(this._allResults ? DefaultPreferenceFactory.ALL_RESULTS.getKey() : DefaultPreferenceFactory.ONLY_FAILURES.getKey()).append('\n');
        return new TextResult(new String(stringBuffer));
    }

    @Override
    public String render(Result result) {
        StringBuffer stringBuffer = new StringBuffer();
        this.render(stringBuffer, result);
        return new String(stringBuffer);
    }

    private void render(StringBuffer stringBuffer, Result result) {
        if (result instanceof ResultContainer) {
            ResultContainer resultContainer = (ResultContainer)result;
            int n = resultContainer.getNumberOfResults();
            for (int i = 0; i < n; ++i) {
                this.render(stringBuffer, resultContainer.getResult(i));
            }
        } else if (this._allResults || !result.isOk()) {
            stringBuffer.append(result.toString());
        }
    }
}

