/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.CommandLine;
import classycle.dependency.DefaultResultRenderer;
import classycle.dependency.ResultRenderer;
import classycle.util.Text;
import java.io.File;
import java.io.IOException;

public class DependencyCheckerCommandLine
extends CommandLine {
    private static final String DEPENDENCIES = "-dependencies=";
    private static final String RENDERER = "-renderer=";
    private String _dependencyDefinition;
    private ResultRenderer _renderer;

    public DependencyCheckerCommandLine(String[] stringArray) {
        super(stringArray);
    }

    @Override
    protected void handleOption(String string) {
        if (string.startsWith(DEPENDENCIES)) {
            this.handleDependenciesOption(string.substring(DEPENDENCIES.length()));
        } else if (string.startsWith(RENDERER)) {
            this.handleRenderer(string.substring(RENDERER.length()));
        } else {
            super.handleOption(string);
        }
    }

    @Override
    public String getUsage() {
        return "-dependencies=<description>|@<description file> [-renderer=<fully qualified class name of a ResultRenderer>] " + super.getUsage();
    }

    public String getDependencyDefinition() {
        return this._dependencyDefinition;
    }

    public ResultRenderer getRenderer() {
        return this._renderer == null ? new DefaultResultRenderer() : this._renderer;
    }

    private void handleDependenciesOption(String string) {
        if (string.startsWith("@")) {
            try {
                string = Text.readTextFile(new File(string.substring(1)));
            }
            catch (IOException iOException) {
                System.err.println("Error in reading dependencies description file: " + iOException);
                string = "";
            }
        }
        this._dependencyDefinition = string;
        if (this._dependencyDefinition.length() == 0) {
            this._valid = false;
        }
    }

    private void handleRenderer(String string) {
        try {
            this._renderer = (ResultRenderer)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println("Error in creating ResultRenderer " + string + ": " + exception);
            this._valid = false;
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this._dependencyDefinition != null;
    }
}

