/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DependencyPathRenderer;
import classycle.dependency.PatternVertexCondition;
import classycle.graph.NameAttributes;
import classycle.graph.Vertex;
import classycle.graph.VertexCondition;
import classycle.util.StringPattern;
import java.util.HashSet;
import java.util.Set;

public class DependencyPathsRenderer {
    private static final String INDENT = "  ";
    private final Vertex[] _graph;
    private final VertexCondition _startSetCondition;
    private final VertexCondition _finalSetCondition;
    private final Set<Vertex> _vertices = new HashSet<Vertex>();

    public DependencyPathsRenderer(Vertex[] vertexArray, StringPattern stringPattern, StringPattern stringPattern2) {
        this(vertexArray, new PatternVertexCondition(stringPattern), new PatternVertexCondition(stringPattern2));
    }

    public DependencyPathsRenderer(Vertex[] vertexArray, VertexCondition vertexCondition, VertexCondition vertexCondition2) {
        this._graph = vertexArray;
        this._startSetCondition = vertexCondition;
        this._finalSetCondition = vertexCondition2;
        for (int i = 0; i < vertexArray.length; ++i) {
            this._vertices.add(vertexArray[i]);
        }
    }

    public String renderGraph(final String string) {
        final StringBuffer stringBuffer = new StringBuffer();
        DependencyPathRenderer dependencyPathRenderer = new DependencyPathRenderer(){
            String _start;
            private int _indentation;
            {
                this._start = '\n' + string;
            }

            @Override
            public void increaseIndentation() {
                ++this._indentation;
            }

            @Override
            public void add(String string2) {
                stringBuffer.append(this._start);
                for (int i = 0; i < this._indentation; ++i) {
                    stringBuffer.append(DependencyPathsRenderer.INDENT);
                }
                if (this._indentation > 0) {
                    stringBuffer.append("-> ");
                }
                stringBuffer.append(string2);
            }

            @Override
            public void decreaseIndentation() {
                --this._indentation;
            }
        };
        this.renderGraph(dependencyPathRenderer);
        return new String(stringBuffer);
    }

    public void renderGraph(DependencyPathRenderer dependencyPathRenderer) {
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        for (int i = 0; i < this._graph.length; ++i) {
            Vertex vertex = this._graph[i];
            if (!this._startSetCondition.isFulfilled(vertex)) continue;
            dependencyPathRenderer.add(this.getNameOf(vertex));
            this.renderPaths(dependencyPathRenderer, vertex, hashSet);
        }
    }

    private void renderPaths(DependencyPathRenderer dependencyPathRenderer, Vertex vertex, Set<Vertex> set) {
        set.add(vertex);
        dependencyPathRenderer.increaseIndentation();
        int n = vertex.getNumberOfOutgoingArcs();
        for (int i = 0; i < n; ++i) {
            Vertex vertex2 = vertex.getHeadVertex(i);
            if (!this._vertices.contains(vertex2) || this._startSetCondition.isFulfilled(vertex2)) continue;
            dependencyPathRenderer.add(this.getNameOf(vertex2));
            if (this._finalSetCondition.isFulfilled(vertex2) || set.contains(vertex2)) continue;
            this.renderPaths(dependencyPathRenderer, vertex2, set);
        }
        dependencyPathRenderer.decreaseIndentation();
    }

    private String getNameOf(Vertex vertex) {
        return ((NameAttributes)vertex.getAttributes()).getName();
    }
}

