/*
 * Decompiled with CFR 0.152.
 */
package classycle.util;

import classycle.util.OrStringPattern;
import classycle.util.StringPattern;
import java.util.StringTokenizer;

public class WildCardPattern
implements StringPattern {
    private static final String WILD_CARD = "*";
    private final String _pattern;
    private final String[] _constantParts;
    private final boolean _startsWithAnything;
    private final boolean _endsWithAnything;

    public static StringPattern createFromsPatterns(String string, String string2) {
        if (string2.indexOf(WILD_CARD) >= 0) {
            throw new IllegalArgumentException("No wild card '*' are allowed as delimiters: " + string2);
        }
        OrStringPattern orStringPattern = new OrStringPattern(new StringPattern[0]);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            orStringPattern.appendPattern(new WildCardPattern(stringTokenizer.nextToken().trim()));
        }
        return orStringPattern;
    }

    public WildCardPattern(String string) {
        this._pattern = string;
        this._startsWithAnything = string.startsWith(WILD_CARD);
        this._endsWithAnything = string.endsWith(WILD_CARD);
        StringTokenizer stringTokenizer = new StringTokenizer(string, WILD_CARD);
        this._constantParts = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < this._constantParts.length; ++i) {
            this._constantParts[i] = stringTokenizer.nextToken();
        }
    }

    public String toString() {
        return this._pattern;
    }

    @Override
    public boolean matches(String string) {
        return string == null ? false : this.matches(string, 0, 0);
    }

    private boolean matches(String string, int n, int n2) {
        boolean bl = true;
        if (n2 < this._constantParts.length) {
            int n3;
            String string2 = this._constantParts[n2];
            do {
                if ((n3 = string.indexOf(string2, n)) >= 0 && (n != 0 || this._startsWithAnything || n3 <= 0)) continue;
                bl = false;
                break;
            } while (!(bl = this.matches(string, n = n3 + string2.length(), n2 + 1)));
        } else {
            bl = bl && (this._endsWithAnything || n == string.length());
        }
        return bl;
    }
}

