/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.matcher;

import org.specs2.matcher.PathBaseMatchers;
import org.specs2.matcher.PathMatcher;
import org.specs2.text.Quote$;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;

public abstract class PathBaseMatchers$class {
    public static PathMatcher beAnExistingPath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String s) {
                return this.$outer.exists(s);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "exists", "doesn't exist");
    }

    public static PathMatcher beAReadablePath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String s) {
                return this.$outer.canRead(s);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "is readable", "can't be read");
    }

    public static PathMatcher beAWritablePath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String s) {
                return this.$outer.canWrite(s);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "is writable", "can't be written");
    }

    public static PathMatcher beAnAbsolutePath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String s) {
                return this.$outer.isAbsolute(s);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "is absolute", "is not absolute");
    }

    public static PathMatcher beAHiddenPath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String s) {
                return this.$outer.isHidden(s);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "is hidden", "is not hidden");
    }

    public static PathMatcher beAFilePath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String s) {
                return this.$outer.isFile(s);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "is a file", "is not a file");
    }

    public static PathMatcher beADirectoryPath(PathBaseMatchers $this) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String s) {
                return this.$outer.isDirectory(s);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "is a directory", "is not a directory");
    }

    public static PathMatcher havePathName(PathBaseMatchers $this, String name$1) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this, name$1){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;
            private final String name$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String s) {
                return PathBaseMatchers$class.org$specs2$matcher$PathBaseMatchers$$isEqualIgnoringSep(this.$outer, this.$outer.getName(s), this.name$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.name$1 = string;
            }
        }, new StringBuilder().append((Object)"is named ").append((Object)Quote$.MODULE$.q(name$1)).toString(), new StringBuilder().append((Object)"is not named ").append((Object)Quote$.MODULE$.q(name$1)).toString());
    }

    public static PathMatcher haveAsAbsolutePath(PathBaseMatchers $this, String path$1) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this, path$1){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;
            private final String path$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String s) {
                return PathBaseMatchers$class.org$specs2$matcher$PathBaseMatchers$$isEqualIgnoringSep(this.$outer, s, this.path$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.path$1 = string;
            }
        }, new StringBuilder().append((Object)"has absolute path ").append((Object)Quote$.MODULE$.q(path$1)).toString(), new StringBuilder().append((Object)"doesn't have absolute path ").append((Object)Quote$.MODULE$.q(path$1)).toString());
    }

    public static PathMatcher haveAsCanonicalPath(PathBaseMatchers $this, String path$2) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this, path$2){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;
            private final String path$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String s) {
                return PathBaseMatchers$class.org$specs2$matcher$PathBaseMatchers$$isEqualIgnoringSep(this.$outer, this.$outer.getCanonicalPath(s), this.path$2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.path$2 = string;
            }
        }, new StringBuilder().append((Object)"has canonical path ").append((Object)Quote$.MODULE$.q(path$2)).toString(), new StringBuilder().append((Object)"doesn't have canonical path ").append((Object)Quote$.MODULE$.q(path$2)).toString());
    }

    public static PathMatcher haveParentPath(PathBaseMatchers $this, String parent$1) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this, parent$1){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;
            private final String parent$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String s) {
                return PathBaseMatchers$class.org$specs2$matcher$PathBaseMatchers$$isEqualIgnoringSep(this.$outer, this.$outer.getParent(s), this.parent$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.parent$1 = string;
            }
        }, new StringBuilder().append((Object)"has parent path ").append((Object)Quote$.MODULE$.q(parent$1)).toString(), new StringBuilder().append((Object)"doesn't have parent path ").append((Object)Quote$.MODULE$.q(parent$1)).toString());
    }

    public static PathMatcher listPaths(PathBaseMatchers $this, Seq list$1) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this, list$1){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;
            private final Seq list$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(String s) {
                if (this.list$1 == null) return false;
                List list = this.$outer.listFiles(s).toList();
                List list2 = this.list$1.toList();
                if (list != null) {
                    if (!list.equals(list2)) return false;
                    return true;
                }
                if (list2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.list$1 = seq;
            }
        }, new StringBuilder().append((Object)"has files ").append((Object)Quote$.MODULE$.q(list$1.mkString(", "))).toString(), new StringBuilder().append((Object)"doesn't have files ").append((Object)Quote$.MODULE$.q(list$1.toList().mkString(", "))).toString());
    }

    public static PathMatcher beEqualToIgnoringSep(PathBaseMatchers $this, String other$1) {
        return new PathMatcher((Function1<String, Object>)new Serializable($this, other$1){
            public static final long serialVersionUID;
            private final PathBaseMatchers $outer;
            private final String other$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String s) {
                return PathBaseMatchers$class.org$specs2$matcher$PathBaseMatchers$$isEqualIgnoringSep(this.$outer, this.$outer.getCanonicalPath(s), this.other$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$1 = string;
            }
        }, new StringBuilder().append((Object)"is equal ignoring separators to ").append((Object)Quote$.MODULE$.q(other$1)).toString(), new StringBuilder().append((Object)"is not equal ignoring separators to ").append((Object)Quote$.MODULE$.q(other$1)).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean org$specs2$matcher$PathBaseMatchers$$isEqualIgnoringSep(PathBaseMatchers $this, String path, String other) {
        if (path == null) return false;
        if (other == null) return false;
        String string = $this.getCanonicalPath(path).replaceAll("\\\\", "/");
        String string2 = $this.getCanonicalPath(other).replaceAll("\\\\", "/");
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static void $init$(PathBaseMatchers $this) {
    }
}

