/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import com.rabbitmq.client.Channel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.listener.adapter.ReplyFailureException;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;

public abstract class AbstractAdaptableMessageListener
implements MessageListener,
ChannelAwareMessageListener {
    private static final String DEFAULT_RESPONSE_ROUTING_KEY = "";
    private static final String DEFAULT_ENCODING = "UTF-8";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String responseRoutingKey = "";
    private String responseExchange = null;
    private volatile boolean mandatoryPublish;
    private MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile MessagePropertiesConverter messagePropertiesConverter = new DefaultMessagePropertiesConverter();
    private String encoding = "UTF-8";
    private MessagePostProcessor replyPostProcessor;

    public void setResponseRoutingKey(String responseRoutingKey) {
        this.responseRoutingKey = responseRoutingKey;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setResponseExchange(String responseExchange) {
        this.responseExchange = responseExchange;
    }

    public void setMandatoryPublish(boolean mandatoryPublish) {
        this.mandatoryPublish = mandatoryPublish;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setReplyPostProcessor(MessagePostProcessor replyPostProcessor) {
        this.replyPostProcessor = replyPostProcessor;
    }

    protected MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void onMessage(Message message) {
        try {
            this.onMessage(message, null);
        }
        catch (Throwable ex) {
            this.handleListenerException(ex);
        }
    }

    protected void handleListenerException(Throwable ex) {
        this.logger.error((Object)"Listener execution failed", ex);
    }

    protected Object extractMessage(Message message) {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null) {
            return converter.fromMessage(message);
        }
        return message;
    }

    protected void handleResult(Object result, Message request, Channel channel) throws Exception {
        if (channel != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Listener method returned result [" + result + "] - generating response message for it"));
            }
            try {
                Message response = this.buildMessage(channel, result);
                this.postProcessResponse(request, response);
                Address replyTo = this.getReplyToAddress(request);
                this.sendResponse(channel, replyTo, response);
            }
            catch (Exception ex) {
                throw new ReplyFailureException("Failed to send reply with payload '" + result + "'", ex);
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Listener method returned result [" + result + "]: not generating response message for it because of no Rabbit Channel given"));
        }
    }

    protected String getReceivedExchange(Message request) {
        return request.getMessageProperties().getReceivedExchange();
    }

    protected Message buildMessage(Channel channel, Object result) throws Exception {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null && !(result instanceof Message)) {
            return converter.toMessage(result, new MessageProperties());
        }
        if (!(result instanceof Message)) {
            throw new MessageConversionException("No MessageConverter specified - cannot handle message [" + result + "]");
        }
        return (Message)result;
    }

    protected void postProcessResponse(Message request, Message response) throws Exception {
        String messageId;
        byte[] correlation = request.getMessageProperties().getCorrelationId();
        if (correlation == null && (messageId = request.getMessageProperties().getMessageId()) != null) {
            correlation = messageId.getBytes(DEFAULT_ENCODING);
        }
        response.getMessageProperties().setCorrelationId(correlation);
    }

    protected Address getReplyToAddress(Message request) throws Exception {
        Address replyTo = request.getMessageProperties().getReplyToAddress();
        if (replyTo == null) {
            if (this.responseExchange == null) {
                throw new AmqpException("Cannot determine ReplyTo message property value: Request message does not contain reply-to property, and no default response Exchange was set.");
            }
            replyTo = new Address(this.responseExchange, this.responseRoutingKey);
        }
        return replyTo;
    }

    protected void sendResponse(Channel channel, Address replyTo, Message messageIn) throws Exception {
        Message message = this.replyPostProcessor == null ? messageIn : this.replyPostProcessor.postProcessMessage(messageIn);
        this.postProcessChannel(channel, message);
        try {
            this.logger.debug((Object)("Publishing response to exchange = [" + replyTo.getExchangeName() + "], routingKey = [" + replyTo.getRoutingKey() + "]"));
            channel.basicPublish(replyTo.getExchangeName(), replyTo.getRoutingKey(), this.mandatoryPublish, this.messagePropertiesConverter.fromMessageProperties(message.getMessageProperties(), this.encoding), message.getBody());
        }
        catch (Exception ex) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(ex);
        }
    }

    protected void postProcessChannel(Channel channel, Message response) throws Exception {
    }
}

