/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.actuator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.client.actuator.NamedFeature;

public final class HasFeatures {
    private final List<Class> abstractFeatures;
    private final List<NamedFeature> namedFeatures;

    public static HasFeatures abstractFeatures(Class ... abstractFeatures) {
        return new HasFeatures(Arrays.asList(abstractFeatures), Collections.emptyList());
    }

    public static HasFeatures namedFeatures(NamedFeature ... namedFeatures) {
        return new HasFeatures(Collections.emptyList(), Arrays.asList(namedFeatures));
    }

    public static HasFeatures namedFeature(String name, Class<?> type) {
        return HasFeatures.namedFeatures(new NamedFeature(name, type));
    }

    public static HasFeatures namedFeatures(String name1, Class<?> type1, String name2, Class<?> type2) {
        return HasFeatures.namedFeatures(new NamedFeature(name1, type1), new NamedFeature(name2, type2));
    }

    HasFeatures(List<Class> abstractFeatures, List<NamedFeature> namedFeatures) {
        this.abstractFeatures = abstractFeatures;
        this.namedFeatures = namedFeatures;
    }

    public static HasFeaturesBuilder builder() {
        return new HasFeaturesBuilder();
    }

    public List<Class> getAbstractFeatures() {
        return this.abstractFeatures;
    }

    public List<NamedFeature> getNamedFeatures() {
        return this.namedFeatures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasFeatures)) {
            return false;
        }
        HasFeatures other = (HasFeatures)o;
        List<Class> this$abstractFeatures = this.getAbstractFeatures();
        List<Class> other$abstractFeatures = other.getAbstractFeatures();
        if (this$abstractFeatures == null ? other$abstractFeatures != null : !((Object)this$abstractFeatures).equals(other$abstractFeatures)) {
            return false;
        }
        List<NamedFeature> this$namedFeatures = this.getNamedFeatures();
        List<NamedFeature> other$namedFeatures = other.getNamedFeatures();
        return !(this$namedFeatures == null ? other$namedFeatures != null : !((Object)this$namedFeatures).equals(other$namedFeatures));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Class> $abstractFeatures = this.getAbstractFeatures();
        result = result * 59 + ($abstractFeatures == null ? 43 : ((Object)$abstractFeatures).hashCode());
        List<NamedFeature> $namedFeatures = this.getNamedFeatures();
        result = result * 59 + ($namedFeatures == null ? 43 : ((Object)$namedFeatures).hashCode());
        return result;
    }

    public String toString() {
        return "HasFeatures(abstractFeatures=" + this.getAbstractFeatures() + ", namedFeatures=" + this.getNamedFeatures() + ")";
    }

    public static class HasFeaturesBuilder {
        private ArrayList<Class> abstractFeatures;
        private ArrayList<NamedFeature> namedFeatures;

        HasFeaturesBuilder() {
        }

        public HasFeaturesBuilder abstractFeature(Class abstractFeature) {
            if (this.abstractFeatures == null) {
                this.abstractFeatures = new ArrayList();
            }
            this.abstractFeatures.add(abstractFeature);
            return this;
        }

        public HasFeaturesBuilder abstractFeatures(Collection<? extends Class> abstractFeatures) {
            if (this.abstractFeatures == null) {
                this.abstractFeatures = new ArrayList();
            }
            this.abstractFeatures.addAll(abstractFeatures);
            return this;
        }

        public HasFeaturesBuilder namedFeature(NamedFeature namedFeature) {
            if (this.namedFeatures == null) {
                this.namedFeatures = new ArrayList();
            }
            this.namedFeatures.add(namedFeature);
            return this;
        }

        public HasFeaturesBuilder namedFeatures(Collection<? extends NamedFeature> namedFeatures) {
            if (this.namedFeatures == null) {
                this.namedFeatures = new ArrayList();
            }
            this.namedFeatures.addAll(namedFeatures);
            return this;
        }

        public HasFeatures build() {
            List<NamedFeature> namedFeatures;
            List<Class> abstractFeatures;
            switch (this.abstractFeatures == null ? 0 : this.abstractFeatures.size()) {
                case 0: {
                    abstractFeatures = Collections.emptyList();
                    break;
                }
                case 1: {
                    abstractFeatures = Collections.singletonList(this.abstractFeatures.get(0));
                    break;
                }
                default: {
                    abstractFeatures = Collections.unmodifiableList(new ArrayList<Class>(this.abstractFeatures));
                }
            }
            switch (this.namedFeatures == null ? 0 : this.namedFeatures.size()) {
                case 0: {
                    namedFeatures = Collections.emptyList();
                    break;
                }
                case 1: {
                    namedFeatures = Collections.singletonList(this.namedFeatures.get(0));
                    break;
                }
                default: {
                    namedFeatures = Collections.unmodifiableList(new ArrayList<NamedFeature>(this.namedFeatures));
                }
            }
            return new HasFeatures(abstractFeatures, namedFeatures);
        }

        public String toString() {
            return "HasFeatures.HasFeaturesBuilder(abstractFeatures=" + this.abstractFeatures + ", namedFeatures=" + this.namedFeatures + ")";
        }
    }
}

