/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.mongodb;

import com.mongodb.ContextProvider;
import com.mongodb.MongoClientSettings;
import com.mongodb.RequestContext;
import com.mongodb.client.SynchronousContextProvider;
import com.mongodb.reactivestreams.client.ReactiveContextProvider;
import org.reactivestreams.Subscriber;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceReactiveMongoClientSettingsBuilderCustomizer;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceSynchronousMongoClientSettingsBuilderCustomizer;

public class TraceAllTypesMongoClientSettingsBuilderCustomizer
implements MongoClientSettingsBuilderCustomizer {
    private final Tracer tracer;

    public TraceAllTypesMongoClientSettingsBuilderCustomizer(Tracer tracer) {
        this.tracer = tracer;
    }

    public void customize(MongoClientSettings.Builder clientSettingsBuilder) {
        clientSettingsBuilder.contextProvider((ContextProvider)new AllTypesContextProvider(this.tracer));
    }

    static class AllTypesContextProvider
    implements SynchronousContextProvider,
    ReactiveContextProvider {
        private final SynchronousContextProvider synchronousContextProvider;
        private final ReactiveContextProvider reactiveContextProvider;

        AllTypesContextProvider(Tracer tracer) {
            this.synchronousContextProvider = TraceSynchronousMongoClientSettingsBuilderCustomizer.contextProvider(tracer);
            this.reactiveContextProvider = TraceReactiveMongoClientSettingsBuilderCustomizer.contextProvider();
        }

        public RequestContext getContext() {
            return this.synchronousContextProvider.getContext();
        }

        public RequestContext getContext(Subscriber<?> subscriber) {
            return this.reactiveContextProvider.getContext(subscriber);
        }
    }
}

