/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.util.MimeType;

public class StringConvertingContentTypeResolver
extends DefaultContentTypeResolver {
    private ConcurrentMap<String, MimeType> mimeTypeCache = new ConcurrentHashMap<String, MimeType>();

    public MimeType resolve(MessageHeaders headers) {
        return this.resolve((Map<String, Object>)headers);
    }

    public MimeType resolve(Map<String, Object> headers) {
        MimeType mimeType = null;
        Object value = headers.get("contentType");
        if (value instanceof MimeType) {
            mimeType = (MimeType)value;
        } else if (value instanceof String && (mimeType = (MimeType)this.mimeTypeCache.get(value)) == null) {
            String valueAsString = (String)value;
            mimeType = MimeType.valueOf((String)valueAsString);
            this.mimeTypeCache.put(valueAsString, mimeType);
        }
        return mimeType != null ? mimeType : this.getDefaultMimeType();
    }
}

