/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.QueryStatementCreator;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class CassandraRepositoryQuerySupport
implements RepositoryQuery {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CassandraQueryMethod queryMethod;
    private final EntityInstantiators instantiators;
    private final QueryStatementCreator queryStatementCreator;

    public CassandraRepositoryQuerySupport(CassandraQueryMethod queryMethod) {
        Assert.notNull((Object)((Object)queryMethod), (String)"CassandraQueryMethod must not be null");
        this.queryMethod = queryMethod;
        this.instantiators = new EntityInstantiators();
        this.queryStatementCreator = new QueryStatementCreator(queryMethod);
    }

    public CassandraQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected EntityInstantiators getEntityInstantiators() {
        return this.instantiators;
    }

    protected QueryStatementCreator getQueryStatementCreator() {
        return this.queryStatementCreator;
    }

    class CassandraReturnedType {
        private final ReturnedType returnedType;
        private final CustomConversions customConversions;

        boolean isProjecting() {
            if (!this.returnedType.isProjecting()) {
                return false;
            }
            if (ClassUtils.isAssignable(Map.class, (Class)this.returnedType.getReturnedType())) {
                return false;
            }
            if (this.customConversions.hasCustomWriteTarget(this.returnedType.getReturnedType())) {
                return false;
            }
            return !this.customConversions.isSimpleType(this.returnedType.getReturnedType());
        }

        Class<?> getDomainType() {
            return this.returnedType.getDomainType();
        }

        Class<?> getReturnedType() {
            return this.returnedType.getReturnedType();
        }

        public CassandraReturnedType(ReturnedType returnedType, CustomConversions customConversions) {
            this.returnedType = returnedType;
            this.customConversions = customConversions;
        }
    }
}

