/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.lang.reflect.Method;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableArgumentResolver;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PageableDefaults;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.data.web.SpringDataAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageableHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String INVALID_DEFAULT_PAGE_SIZE = "Invalid default page size configured for method %s! Must not be less than one!";
    @Deprecated
    public static final PageableHandlerMethodArgumentResolver LEGACY = new PageableHandlerMethodArgumentResolver();
    private static final String DEFAULT_PAGE_PARAMETER = "page";
    private static final String DEFAULT_SIZE_PARAMETER = "size";
    private static final String DEFAULT_PREFIX = "";
    private static final String DEFAULT_QUALIFIER_DELIMITER = "_";
    private static final int DEFAULT_MAX_PAGE_SIZE = 2000;
    static final Pageable DEFAULT_PAGE_REQUEST;
    private Pageable fallbackPageable = DEFAULT_PAGE_REQUEST;
    private SortHandlerMethodArgumentResolver sortResolver;
    private String pageParameterName = "page";
    private String sizeParameterName = "size";
    private String prefix = "";
    private String qualifierDelimiter = "_";
    private int maxPageSize = 2000;
    private boolean oneIndexedParameters = false;

    public PageableHandlerMethodArgumentResolver() {
        this(null);
    }

    public PageableHandlerMethodArgumentResolver(SortHandlerMethodArgumentResolver sortResolver) {
        this.sortResolver = sortResolver == null ? new SortHandlerMethodArgumentResolver() : sortResolver;
    }

    public void setFallbackPageable(Pageable fallbackPageable) {
        this.fallbackPageable = fallbackPageable;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    protected int getMaxPageSize() {
        return this.maxPageSize;
    }

    public void setPageParameterName(String pageParameterName) {
        Assert.hasText((String)pageParameterName, (String)"Page parameter name must not be null or empty!");
        this.pageParameterName = pageParameterName;
    }

    protected String getPageParameterName() {
        return this.pageParameterName;
    }

    public void setSizeParameterName(String sizeParameterName) {
        Assert.hasText((String)sizeParameterName, (String)"Size parameter name must not be null or empty!");
        this.sizeParameterName = sizeParameterName;
    }

    protected String getSizeParameterName() {
        return this.sizeParameterName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix == null ? DEFAULT_PREFIX : prefix;
    }

    public void setQualifierDelimiter(String qualifierDelimiter) {
        this.qualifierDelimiter = qualifierDelimiter == null ? DEFAULT_QUALIFIER_DELIMITER : qualifierDelimiter;
    }

    public void setOneIndexedParameters(boolean oneIndexedParameters) {
        this.oneIndexedParameters = oneIndexedParameters;
    }

    protected boolean isOneIndexedParameters() {
        return this.oneIndexedParameters;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return Pageable.class.equals((Object)parameter.getParameterType());
    }

    public Pageable resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        boolean pageAndSizeGiven;
        SpringDataAnnotationUtils.assertPageableUniqueness(methodParameter);
        Pageable defaultOrFallback = this.getDefaultFromAnnotationOrFallback(methodParameter);
        String pageString = webRequest.getParameter(this.getParameterNameToUse(this.pageParameterName, methodParameter));
        String pageSizeString = webRequest.getParameter(this.getParameterNameToUse(this.sizeParameterName, methodParameter));
        boolean bl = pageAndSizeGiven = StringUtils.hasText((String)pageString) && StringUtils.hasText((String)pageSizeString);
        if (!pageAndSizeGiven && defaultOrFallback == null) {
            return null;
        }
        int page = StringUtils.hasText((String)pageString) ? PageableHandlerMethodArgumentResolver.parseAndApplyBoundaries(pageString, 0, Integer.MAX_VALUE) - (this.oneIndexedParameters ? 1 : 0) : defaultOrFallback.getPageNumber();
        int pageSize = StringUtils.hasText((String)pageSizeString) ? PageableHandlerMethodArgumentResolver.parseAndApplyBoundaries(pageSizeString, 0, this.maxPageSize) : defaultOrFallback.getPageSize();
        pageSize = pageSize < 1 ? defaultOrFallback.getPageSize() : pageSize;
        pageSize = pageSize > this.maxPageSize ? this.maxPageSize : pageSize;
        Sort sort = this.sortResolver.resolveArgument(methodParameter, mavContainer, webRequest, binderFactory);
        return new PageRequest(page, pageSize, sort == null ? defaultOrFallback.getSort() : sort);
    }

    protected String getParameterNameToUse(String source, MethodParameter parameter) {
        StringBuilder builder = new StringBuilder(this.prefix);
        if (parameter != null && parameter.hasParameterAnnotation(Qualifier.class)) {
            builder.append(((Qualifier)parameter.getParameterAnnotation(Qualifier.class)).value());
            builder.append(this.qualifierDelimiter);
        }
        return builder.append(source).toString();
    }

    private Pageable getDefaultFromAnnotationOrFallback(MethodParameter methodParameter) {
        if (this.sortResolver.legacyMode && methodParameter.hasParameterAnnotation(PageableDefaults.class)) {
            Pageable pageable = PageableArgumentResolver.getDefaultPageRequestFrom((PageableDefaults)methodParameter.getParameterAnnotation(PageableDefaults.class));
            return new PageRequest(pageable.getPageNumber() - 1, pageable.getPageSize(), pageable.getSort());
        }
        if (methodParameter.hasParameterAnnotation(PageableDefault.class)) {
            return PageableHandlerMethodArgumentResolver.getDefaultPageRequestFrom(methodParameter);
        }
        return this.fallbackPageable;
    }

    private static Pageable getDefaultPageRequestFrom(MethodParameter parameter) {
        PageableDefault defaults = (PageableDefault)parameter.getParameterAnnotation(PageableDefault.class);
        Integer defaultPageNumber = defaults.page();
        Integer defaultPageSize = (Integer)SpringDataAnnotationUtils.getSpecificPropertyOrDefaultFromValue(defaults, DEFAULT_SIZE_PARAMETER);
        if (defaultPageSize < 1) {
            Method annotatedMethod = parameter.getMethod();
            throw new IllegalStateException(String.format(INVALID_DEFAULT_PAGE_SIZE, annotatedMethod));
        }
        if (defaults.sort().length == 0) {
            return new PageRequest(defaultPageNumber, defaultPageSize);
        }
        return new PageRequest(defaultPageNumber, defaultPageSize, defaults.direction(), defaults.sort());
    }

    private static int parseAndApplyBoundaries(String parameter, int lower, int upper) {
        try {
            int parsed = Integer.parseInt(parameter);
            return parsed < lower ? lower : (parsed > upper ? upper : parsed);
        }
        catch (NumberFormatException e) {
            return lower;
        }
    }

    static {
        PageableHandlerMethodArgumentResolver.LEGACY.pageParameterName = "page.page";
        PageableHandlerMethodArgumentResolver.LEGACY.sizeParameterName = "page.size";
        PageableHandlerMethodArgumentResolver.LEGACY.fallbackPageable = new PageRequest(1, 10);
        PageableHandlerMethodArgumentResolver.LEGACY.oneIndexedParameters = true;
        PageableHandlerMethodArgumentResolver.LEGACY.sortResolver.setLegacyMode(true);
        PageableHandlerMethodArgumentResolver.LEGACY.sortResolver.setSortParameter("page.sort");
        DEFAULT_PAGE_REQUEST = new PageRequest(0, 20);
    }
}

