/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query.support;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.functions.PatternMatchingFunctions;
import com.couchbase.client.java.query.dsl.functions.StringFunctions;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.repository.query.ConvertingIterator;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.repository.query.parser.Part;

public class N1qlQueryCreatorUtils {
    public static Expression prepareExpression(CouchbaseConverter converter, Part part, Iterator<Object> iterator) {
        boolean isString;
        PersistentPropertyPath<CouchbasePersistentProperty> path = N1qlUtils.getPathWithAlternativeFieldNames(converter, part.getProperty());
        ConvertingIterator parameterValues = new ConvertingIterator(iterator, converter);
        String fieldNamePath = N1qlUtils.getDottedPathWithAlternativeFieldNames(path);
        boolean ignoreCase = false;
        Class<?> leafType = converter.getWriteClassFor(((CouchbasePersistentProperty)path.getLeafProperty()).getType());
        boolean bl = isString = leafType == String.class;
        if (part.shouldIgnoreCase() == Part.IgnoreCaseType.WHEN_POSSIBLE) {
            ignoreCase = isString;
        } else if (part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS) {
            if (!isString) {
                throw new IllegalArgumentException(String.format("Part %s must be of type String but was %s", fieldNamePath, leafType));
            }
            ignoreCase = true;
        }
        return N1qlQueryCreatorUtils.createExpression(part.getType(), fieldNamePath, ignoreCase, parameterValues);
    }

    public static Expression createExpression(Part.Type partType, String fieldNamePath, boolean ignoreCase, Iterator<Object> parameterValues) {
        Expression left = ignoreCase ? StringFunctions.lower((Expression)Expression.x((String)fieldNamePath)) : Expression.x((String)fieldNamePath);
        switch (partType) {
            case BETWEEN: {
                return left.between(N1qlQueryCreatorUtils.leftAndRight(parameterValues, ignoreCase));
            }
            case IS_NOT_NULL: {
                return left.isNotNull();
            }
            case IS_NULL: {
                return left.isNull();
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return left.ne(N1qlQueryCreatorUtils.right(parameterValues, ignoreCase));
            }
            case SIMPLE_PROPERTY: {
                return left.eq(N1qlQueryCreatorUtils.right(parameterValues, ignoreCase));
            }
            case BEFORE: 
            case LESS_THAN: {
                return left.lt(N1qlQueryCreatorUtils.right(parameterValues, ignoreCase));
            }
            case LESS_THAN_EQUAL: {
                return left.lte(N1qlQueryCreatorUtils.right(parameterValues, ignoreCase));
            }
            case GREATER_THAN_EQUAL: {
                return left.gte(N1qlQueryCreatorUtils.right(parameterValues, ignoreCase));
            }
            case AFTER: 
            case GREATER_THAN: {
                return left.gt(N1qlQueryCreatorUtils.right(parameterValues, ignoreCase));
            }
            case NOT_LIKE: {
                return left.notLike(N1qlQueryCreatorUtils.right(parameterValues, ignoreCase));
            }
            case LIKE: {
                return left.like(N1qlQueryCreatorUtils.right(parameterValues, ignoreCase));
            }
            case STARTING_WITH: {
                return left.like(N1qlQueryCreatorUtils.like(parameterValues, ignoreCase, false, true));
            }
            case ENDING_WITH: {
                return left.like(N1qlQueryCreatorUtils.like(parameterValues, ignoreCase, true, false));
            }
            case NOT_CONTAINING: {
                return left.notLike(N1qlQueryCreatorUtils.like(parameterValues, ignoreCase, true, true));
            }
            case CONTAINING: {
                return left.like(N1qlQueryCreatorUtils.like(parameterValues, ignoreCase, true, true));
            }
            case NOT_IN: {
                return left.notIn(N1qlQueryCreatorUtils.rightArray(parameterValues));
            }
            case IN: {
                return left.in(N1qlQueryCreatorUtils.rightArray(parameterValues));
            }
            case TRUE: {
                return left.eq(true);
            }
            case FALSE: {
                return left.eq(false);
            }
            case REGEX: {
                return N1qlQueryCreatorUtils.regexp(fieldNamePath, parameterValues);
            }
            case EXISTS: {
                return left.isNotMissing();
            }
        }
        throw new IllegalArgumentException("Unsupported keyword in N1QL query derivation");
    }

    protected static Expression regexp(String left, Iterator<Object> parameterValues) {
        Object next = parameterValues.next();
        String pattern = next == null ? "" : String.valueOf(next);
        return PatternMatchingFunctions.regexpLike((String)left, (String)pattern);
    }

    protected static Expression leftAndRight(Iterator<Object> parameterValues, boolean ignoreCase) {
        return N1qlQueryCreatorUtils.right(parameterValues, ignoreCase).and(N1qlQueryCreatorUtils.right(parameterValues, ignoreCase));
    }

    protected static Expression like(Iterator<Object> parameterValues, boolean ignoreCase, boolean anyPrefix, boolean anySuffix) {
        Expression converted;
        Object next = parameterValues.next();
        if (next == null) {
            return Expression.NULL();
        }
        if (next instanceof String) {
            String pattern = (String)next;
            if (anyPrefix) {
                pattern = "%" + pattern;
            }
            if (anySuffix) {
                pattern = pattern + "%";
            }
            converted = Expression.s((String[])new String[]{pattern});
        } else {
            converted = Expression.x((String)String.valueOf(next));
        }
        if (ignoreCase) {
            return StringFunctions.lower((Expression)converted);
        }
        return converted;
    }

    protected static Expression right(Iterator<Object> parameterValues, boolean ignoreCase) {
        Object next = parameterValues.next();
        if (next == null) {
            return Expression.NULL();
        }
        Expression converted = next instanceof String ? Expression.s((String[])new String[]{(String)next}) : (next instanceof Enum ? Expression.s((String[])new String[]{String.valueOf(next)}) : Expression.x((String)String.valueOf(next)));
        if (ignoreCase) {
            return StringFunctions.lower((Expression)converted);
        }
        return converted;
    }

    protected static JsonArray rightArray(Iterator<Object> parameterValues) {
        Object next = parameterValues.next();
        Object[] values = next instanceof Collection ? ((Collection)next).toArray() : (next.getClass().isArray() ? (Object[])next : new Object[]{next});
        return JsonArray.from((Object[])values);
    }
}

