/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.elasticsearch.client.RestClientBuilder;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.DefaultClientConfiguration;
import org.springframework.data.elasticsearch.client.InetSocketAddressParser;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;

class ClientConfigurationBuilder
implements ClientConfiguration.ClientConfigurationBuilderWithRequiredEndpoint,
ClientConfiguration.MaybeSecureClientConfigurationBuilder {
    private List<InetSocketAddress> hosts = new ArrayList<InetSocketAddress>();
    private HttpHeaders headers = HttpHeaders.EMPTY;
    private boolean useSsl;
    @Nullable
    private SSLContext sslContext;
    @Nullable
    private HostnameVerifier hostnameVerifier;
    private Duration connectTimeout = Duration.ofSeconds(10L);
    private Duration soTimeout = Duration.ofSeconds(5L);
    @Nullable
    private String username;
    @Nullable
    private String password;
    @Nullable
    private String pathPrefix;
    @Nullable
    private String proxy;
    private Function<WebClient, WebClient> webClientConfigurer = Function.identity();
    private Supplier<HttpHeaders> headersSupplier = () -> HttpHeaders.EMPTY;
    private RestClientBuilder.HttpClientConfigCallback httpClientConfigurer = httpClientBuilder -> httpClientBuilder;

    ClientConfigurationBuilder() {
    }

    @Override
    public ClientConfiguration.MaybeSecureClientConfigurationBuilder connectedTo(String ... hostAndPorts) {
        Assert.notEmpty((Object[])hostAndPorts, (String)"At least one host is required");
        this.hosts.addAll(Arrays.stream(hostAndPorts).map(ClientConfigurationBuilder::parse).collect(Collectors.toList()));
        return this;
    }

    @Override
    public ClientConfiguration.MaybeSecureClientConfigurationBuilder connectedTo(InetSocketAddress ... endpoints) {
        Assert.notEmpty((Object[])endpoints, (String)"At least one endpoint is required");
        this.hosts.addAll(Arrays.asList(endpoints));
        return this;
    }

    @Override
    public ClientConfiguration.MaybeSecureClientConfigurationBuilder withProxy(String proxy) {
        Assert.hasLength((String)proxy, (String)"proxy must not be null or empty");
        this.proxy = proxy;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder usingSsl() {
        this.useSsl = true;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder usingSsl(SSLContext sslContext) {
        Assert.notNull((Object)sslContext, (String)"SSL Context must not be null");
        this.useSsl = true;
        this.sslContext = sslContext;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder usingSsl(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        Assert.notNull((Object)sslContext, (String)"SSL Context must not be null");
        Assert.notNull((Object)hostnameVerifier, (String)"Host Name Verifier must not be null");
        this.useSsl = true;
        this.sslContext = sslContext;
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder withDefaultHeaders(HttpHeaders defaultHeaders) {
        Assert.notNull((Object)defaultHeaders, (String)"Default HTTP headers must not be null");
        this.headers = new HttpHeaders();
        this.headers.addAll((MultiValueMap)defaultHeaders);
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder withConnectTimeout(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"I/O timeout must not be null!");
        this.connectTimeout = timeout;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder withSocketTimeout(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Socket timeout must not be null!");
        this.soTimeout = timeout;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder withBasicAuth(String username, String password) {
        Assert.notNull((Object)username, (String)"username must not be null");
        Assert.notNull((Object)password, (String)"password must not be null");
        this.username = username;
        this.password = password;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder withPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder withWebClientConfigurer(Function<WebClient, WebClient> webClientConfigurer) {
        Assert.notNull(webClientConfigurer, (String)"webClientConfigurer must not be null");
        this.webClientConfigurer = webClientConfigurer;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder withHttpClientConfigurer(RestClientBuilder.HttpClientConfigCallback httpClientConfigurer) {
        Assert.notNull((Object)httpClientConfigurer, (String)"httpClientConfigurer must not be null");
        this.httpClientConfigurer = httpClientConfigurer;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder withHeaders(Supplier<HttpHeaders> headers) {
        Assert.notNull(headers, (String)"headersSupplier must not be null");
        this.headersSupplier = headers;
        return this;
    }

    @Override
    public ClientConfiguration build() {
        if (this.username != null && this.password != null) {
            if (HttpHeaders.EMPTY.equals((Object)this.headers)) {
                this.headers = new HttpHeaders();
            }
            this.headers.setBasicAuth(this.username, this.password);
        }
        return new DefaultClientConfiguration(this.hosts, this.headers, this.useSsl, this.sslContext, this.soTimeout, this.connectTimeout, this.pathPrefix, this.hostnameVerifier, this.proxy, this.webClientConfigurer, this.httpClientConfigurer, this.headersSupplier);
    }

    private static InetSocketAddress parse(String hostAndPort) {
        return InetSocketAddressParser.parse(hostAndPort, 9200);
    }
}

