/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.elasticsearch.client.UnsupportedClientOperationException;
import org.springframework.data.elasticsearch.core.AggregationContainer;
import org.springframework.data.elasticsearch.core.EntityOperations;
import org.springframework.data.elasticsearch.core.IndexedObjectInformation;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ReactiveSearchHitSupport;
import org.springframework.data.elasticsearch.core.ReactiveSearchHits;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHitMapping;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchPage;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.event.ReactiveAfterConvertCallback;
import org.springframework.data.elasticsearch.core.event.ReactiveAfterLoadCallback;
import org.springframework.data.elasticsearch.core.event.ReactiveAfterSaveCallback;
import org.springframework.data.elasticsearch.core.event.ReactiveBeforeConvertCallback;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SeqNoPrimaryTerm;
import org.springframework.data.elasticsearch.core.routing.DefaultRoutingResolver;
import org.springframework.data.elasticsearch.core.routing.RoutingResolver;
import org.springframework.data.elasticsearch.core.script.Script;
import org.springframework.data.elasticsearch.core.suggest.response.Suggest;
import org.springframework.data.elasticsearch.support.VersionInfo;
import org.springframework.data.mapping.callback.ReactiveEntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.function.Tuple2;

public abstract class AbstractReactiveElasticsearchTemplate
implements ReactiveElasticsearchOperations,
ApplicationContextAware {
    protected final ElasticsearchConverter converter;
    protected final SimpleElasticsearchMappingContext mappingContext;
    protected final EntityOperations entityOperations;
    @Nullable
    protected RefreshPolicy refreshPolicy = RefreshPolicy.NONE;
    protected RoutingResolver routingResolver;
    @Nullable
    protected ReactiveEntityCallbacks entityCallbacks;

    protected AbstractReactiveElasticsearchTemplate(@Nullable ElasticsearchConverter converter) {
        this.converter = converter != null ? converter : this.createElasticsearchConverter();
        this.mappingContext = (SimpleElasticsearchMappingContext)this.converter.getMappingContext();
        this.entityOperations = new EntityOperations((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)this.mappingContext);
        this.routingResolver = new DefaultRoutingResolver((MappingContext<? extends ElasticsearchPersistentEntity<?>, ? extends ElasticsearchPersistentProperty>)this.mappingContext);
        VersionInfo.versionProperties();
    }

    @Override
    public ElasticsearchConverter getElasticsearchConverter() {
        return this.converter;
    }

    private AbstractReactiveElasticsearchTemplate copy() {
        AbstractReactiveElasticsearchTemplate copy = this.doCopy();
        copy.setRefreshPolicy(this.refreshPolicy);
        if (this.entityCallbacks != null) {
            copy.setEntityCallbacks(this.entityCallbacks);
        }
        copy.setRoutingResolver(this.routingResolver);
        return copy;
    }

    protected abstract AbstractReactiveElasticsearchTemplate doCopy();

    private ElasticsearchConverter createElasticsearchConverter() {
        MappingElasticsearchConverter mappingElasticsearchConverter = new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext());
        mappingElasticsearchConverter.afterPropertiesSet();
        return mappingElasticsearchConverter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(ReactiveEntityCallbacks.create((BeanFactory)applicationContext));
        }
    }

    public void setRefreshPolicy(@Nullable RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
    }

    @Nullable
    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void setEntityCallbacks(ReactiveEntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null!");
        this.entityCallbacks = entityCallbacks;
    }

    public Mono<Void> logVersions() {
        return this.getVendor().zipWith(this.getRuntimeLibraryVersion()).zipWith(this.getClusterVersion()).doOnNext(objects -> VersionInfo.logVersions((String)((Tuple2)objects.getT1()).getT1(), (String)((Tuple2)objects.getT1()).getT2(), (String)objects.getT2())).then();
    }

    private void setRoutingResolver(RoutingResolver routingResolver) {
        Assert.notNull((Object)routingResolver, (String)"routingResolver must not be null");
        this.routingResolver = routingResolver;
    }

    @Override
    public ReactiveElasticsearchOperations withRouting(RoutingResolver routingResolver) {
        Assert.notNull((Object)routingResolver, (String)"routingResolver must not be null");
        AbstractReactiveElasticsearchTemplate copy = this.copy();
        copy.setRoutingResolver(routingResolver);
        return copy;
    }

    @Override
    public ReactiveElasticsearchOperations withRefreshPolicy(@Nullable RefreshPolicy refreshPolicy) {
        AbstractReactiveElasticsearchTemplate copy = this.copy();
        copy.setRefreshPolicy(refreshPolicy);
        return copy;
    }

    @Override
    public <T> Mono<T> save(T entity) {
        return this.save(entity, this.getIndexCoordinatesFor(entity.getClass()));
    }

    @Override
    public <T> Flux<T> save(Flux<T> entities, Class<?> clazz, int bulkSize) {
        return this.save(entities, this.getIndexCoordinatesFor(clazz), bulkSize);
    }

    @Override
    public <T> Flux<T> save(Flux<T> entities, final IndexCoordinates index, int bulkSize) {
        Assert.notNull(entities, (String)"entities must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.isTrue((bulkSize > 0 ? 1 : 0) != 0, (String)"bulkSize must be greater than 0");
        return Flux.defer(() -> {
            final Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
            entities.bufferTimeout(bulkSize, Duration.ofMillis(200L), true).subscribe(new Subscriber<List<T>>(){
                @Nullable
                private Subscription subscription = null;
                private final AtomicBoolean upstreamComplete = new AtomicBoolean(false);

                public void onSubscribe(Subscription subscription) {
                    this.subscription = subscription;
                    subscription.request(1L);
                }

                public void onNext(List<T> entityList) {
                    AbstractReactiveElasticsearchTemplate.this.saveAll(entityList, index).map(arg_0 -> ((Sinks.Many)sink).tryEmitNext(arg_0)).doOnComplete(() -> {
                        if (!this.upstreamComplete.get()) {
                            if (this.subscription == null) {
                                throw new IllegalStateException("no subscription");
                            }
                            this.subscription.request(1L);
                        } else {
                            sink.tryEmitComplete();
                        }
                    }).subscribe();
                }

                public void onError(Throwable throwable) {
                    if (this.subscription != null) {
                        this.subscription.cancel();
                    }
                    sink.tryEmitError(throwable);
                }

                public void onComplete() {
                    this.upstreamComplete.set(true);
                }
            });
            return sink.asFlux();
        });
    }

    @Override
    public <T> Flux<T> saveAll(Mono<? extends Collection<? extends T>> entities, Class<T> clazz) {
        return this.saveAll(entities, this.getIndexCoordinatesFor(clazz));
    }

    protected IndexQuery getIndexQuery(Object value) {
        Number version;
        SeqNoPrimaryTerm seqNoPrimaryTerm;
        EntityOperations.AdaptableEntity<Object> entity = this.entityOperations.forEntity(value, this.converter.getConversionService(), this.routingResolver);
        Object id = entity.getId();
        IndexQuery query = new IndexQuery();
        if (id != null) {
            query.setId(id.toString());
        }
        query.setObject(value);
        boolean usingSeqNo = false;
        if (entity.hasSeqNoPrimaryTerm() && (seqNoPrimaryTerm = entity.getSeqNoPrimaryTerm()) != null) {
            query.setSeqNo(seqNoPrimaryTerm.sequenceNumber());
            query.setPrimaryTerm(seqNoPrimaryTerm.primaryTerm());
            usingSeqNo = true;
        }
        if (!usingSeqNo && entity.isVersionedEntity() && (version = entity.getVersion()) != null) {
            query.setVersion(version.longValue());
        }
        query.setRouting(entity.getRouting());
        return query;
    }

    @Override
    public <T> Flux<MultiGetItem<T>> multiGet(Query query, Class<T> clazz) {
        return this.multiGet(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public Mono<Boolean> exists(String id, Class<?> entityType) {
        return this.doExists(id, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public Mono<Boolean> exists(String id, IndexCoordinates index) {
        return this.doExists(id, index);
    }

    @Override
    public <T> Mono<T> save(T entity, IndexCoordinates index) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        Assert.notNull((Object)index, (String)"index must not be null");
        return this.maybeCallbackBeforeConvert(entity, index).flatMap(entityAfterBeforeConversionCallback -> this.doIndex(entityAfterBeforeConversionCallback, index)).map(it -> {
            Object savedEntity = it.getT1();
            IndexResponseMetaData indexResponseMetaData = (IndexResponseMetaData)it.getT2();
            return this.entityOperations.updateIndexedObject(savedEntity, new IndexedObjectInformation(indexResponseMetaData.id(), indexResponseMetaData.index(), indexResponseMetaData.seqNo(), indexResponseMetaData.primaryTerm(), indexResponseMetaData.version()), this.converter, this.routingResolver);
        }).flatMap(saved -> this.maybeCallbackAfterSave(saved, index));
    }

    protected abstract <T> Mono<Tuple2<T, IndexResponseMetaData>> doIndex(T var1, IndexCoordinates var2);

    protected abstract Mono<Boolean> doExists(String var1, IndexCoordinates var2);

    @Override
    public <T> Mono<T> get(String id, Class<T> entityType) {
        return this.get(id, entityType, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public Mono<String> delete(Object entity, IndexCoordinates index) {
        EntityOperations.AdaptableEntity<Object> elasticsearchEntity = this.entityOperations.forEntity(entity, this.converter.getConversionService(), this.routingResolver);
        if (elasticsearchEntity.getId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("entity must have an id"));
        }
        return Mono.defer(() -> {
            String id = this.converter.convertId(elasticsearchEntity.getId());
            String routing = elasticsearchEntity.getRouting();
            return this.doDeleteById(id, routing, index);
        });
    }

    @Override
    public Mono<String> delete(Object entity) {
        return this.delete(entity, this.getIndexCoordinatesFor(entity.getClass()));
    }

    @Override
    public Mono<String> delete(String id, Class<?> entityType) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull(entityType, (String)"entityType must not be null");
        return this.delete(id, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public Mono<String> delete(String id, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return this.doDeleteById(id, this.routingResolver.getRouting(), index);
    }

    protected abstract Mono<String> doDeleteById(String var1, @Nullable String var2, IndexCoordinates var3);

    @Override
    public Mono<ByQueryResponse> delete(Query query, Class<?> entityType) {
        return this.delete(query, entityType, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public <T> Flux<SearchHit<T>> search(Query query, Class<?> entityType, Class<T> resultType, IndexCoordinates index) {
        ReadSearchDocumentCallback<T> callback = new ReadSearchDocumentCallback<T>(resultType, index);
        return this.doFind(query, entityType, index).concatMap(callback::toSearchHit);
    }

    @Override
    public <T> Flux<SearchHit<T>> search(Query query, Class<?> entityType, Class<T> returnType) {
        return this.search(query, entityType, returnType, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public <T> Mono<SearchPage<T>> searchForPage(Query query, Class<?> entityType, Class<T> resultType) {
        return this.searchForPage(query, entityType, resultType, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public <T> Mono<SearchPage<T>> searchForPage(Query query, Class<?> entityType, Class<T> resultType, IndexCoordinates index) {
        ReadSearchDocumentCallback callback = new ReadSearchDocumentCallback(resultType, index);
        return this.doFindForResponse(query, entityType, index).flatMap(searchDocumentResponse -> Flux.fromIterable(searchDocumentResponse.getSearchDocuments()).flatMap(callback::toEntity).collectList().map(entities -> SearchHitMapping.mappingFor(resultType, this.converter).mapHits((SearchDocumentResponse)searchDocumentResponse, entities))).map(searchHits -> SearchHitSupport.searchPageFor(searchHits, query.getPageable()));
    }

    @Override
    public <T> Mono<ReactiveSearchHits<T>> searchForHits(Query query, Class<?> entityType, Class<T> resultType) {
        return this.searchForHits(query, entityType, resultType, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public <T> Mono<ReactiveSearchHits<T>> searchForHits(Query query, Class<?> entityType, Class<T> resultType, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(entityType, (String)"entityType must not be null");
        Assert.notNull(resultType, (String)"resultType must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        ReadSearchDocumentCallback callback = new ReadSearchDocumentCallback(resultType, index);
        return this.doFindForResponse(query, entityType, index).flatMap(searchDocumentResponse -> Flux.fromIterable(searchDocumentResponse.getSearchDocuments()).flatMap(callback::toEntity).collectList().map(entities -> SearchHitMapping.mappingFor(resultType, this.converter).mapHits((SearchDocumentResponse)searchDocumentResponse, entities))).map(ReactiveSearchHitSupport::searchHitsFor);
    }

    protected abstract Flux<SearchDocument> doFind(Query var1, Class<?> var2, IndexCoordinates var3);

    protected abstract <T> Mono<SearchDocumentResponse> doFindForResponse(Query var1, Class<?> var2, IndexCoordinates var3);

    @Override
    public Flux<? extends AggregationContainer<?>> aggregate(Query query, Class<?> entityType) {
        return this.aggregate(query, entityType, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public Mono<Suggest> suggest(Query query, Class<?> entityType) {
        return this.suggest(query, entityType, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public Mono<Suggest> suggest(Query query, Class<?> entityType, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(entityType, (String)"entityType must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return this.doFindForResponse(query, entityType, index).mapNotNull(searchDocumentResponse -> {
            Suggest suggest = searchDocumentResponse.getSuggest();
            SearchHitMapping.mappingFor(entityType, this.converter).mapHitsInCompletionSuggestion(suggest);
            return suggest;
        });
    }

    @Override
    public Mono<Long> count(Query query, Class<?> entityType) {
        return this.count(query, entityType, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public Mono<Long> count(Query query, Class<?> entityType, IndexCoordinates index) {
        return this.doCount(query, entityType, index);
    }

    protected abstract Mono<Long> doCount(Query var1, Class<?> var2, IndexCoordinates var3);

    @Override
    public Mono<String> openPointInTime(IndexCoordinates index, Duration keepAlive, Boolean ignoreUnavailable) {
        throw new UnsupportedClientOperationException(this.getClass(), "openPointInTime");
    }

    @Override
    public Mono<Boolean> closePointInTime(String pit) {
        throw new UnsupportedClientOperationException(this.getClass(), "closePointInTime");
    }

    protected <T> Mono<T> maybeCallbackBeforeConvert(T entity, IndexCoordinates index) {
        if (null != this.entityCallbacks) {
            return this.entityCallbacks.callback(ReactiveBeforeConvertCallback.class, entity, new Object[]{index});
        }
        return Mono.just(entity);
    }

    protected <T> Mono<T> maybeCallbackAfterSave(T entity, IndexCoordinates index) {
        if (null != this.entityCallbacks) {
            return this.entityCallbacks.callback(ReactiveAfterSaveCallback.class, entity, new Object[]{index});
        }
        return Mono.just(entity);
    }

    protected <T> Mono<T> maybeCallbackAfterConvert(T entity, Document document, IndexCoordinates index) {
        if (null != this.entityCallbacks) {
            return this.entityCallbacks.callback(ReactiveAfterConvertCallback.class, entity, new Object[]{document, index});
        }
        return Mono.just(entity);
    }

    protected <T> Mono<Document> maybeCallbackAfterLoad(Document document, Class<T> type, IndexCoordinates index) {
        if (this.entityCallbacks != null) {
            return this.entityCallbacks.callback(ReactiveAfterLoadCallback.class, (Object)document, new Object[]{type, index});
        }
        return Mono.just((Object)document);
    }

    @Override
    public Mono<Boolean> putScript(Script script) {
        throw new UnsupportedOperationException("putScript() operation not implemented by " + this.getClass().getCanonicalName());
    }

    @Override
    public Mono<Script> getScript(String name) {
        throw new UnsupportedOperationException("getScript() operation not implemented by " + this.getClass().getCanonicalName());
    }

    @Override
    public Mono<Boolean> deleteScript(String name) {
        throw new UnsupportedOperationException("deleteScript() operation not implemented by " + this.getClass().getCanonicalName());
    }

    @Override
    public IndexCoordinates getIndexCoordinatesFor(Class<?> clazz) {
        ElasticsearchPersistentEntity<?> persistentEntity = this.getPersistentEntityFor(clazz);
        Assert.notNull(persistentEntity, (String)("could not get indexCoordinates for class " + clazz.getName()));
        return persistentEntity.getIndexCoordinates();
    }

    @Override
    @Nullable
    public ElasticsearchPersistentEntity<?> getPersistentEntityFor(@Nullable Class<?> type) {
        return type != null ? (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(type) : null;
    }

    public abstract Mono<String> getVendor();

    public abstract Mono<String> getRuntimeLibraryVersion();

    public abstract Mono<String> getClusterVersion();

    @Override
    @Nullable
    public String getEntityRouting(Object entity) {
        return this.entityOperations.forEntity(entity, this.converter.getConversionService(), this.routingResolver).getRouting();
    }

    protected class ReadSearchDocumentCallback<T>
    implements SearchDocumentCallback<T> {
        private final DocumentCallback<T> delegate;
        private final Class<T> type;

        public ReadSearchDocumentCallback(Class<T> type, IndexCoordinates index) {
            Assert.notNull(type, (String)"type is null");
            this.delegate = new ReadDocumentCallback<T>(AbstractReactiveElasticsearchTemplate.this.converter, type, index);
            this.type = type;
        }

        @Override
        public Mono<T> toEntity(SearchDocument response) {
            return this.delegate.toEntity(response);
        }

        @Override
        public Mono<SearchHit<T>> toSearchHit(SearchDocument response) {
            return this.toEntity(response).map(entity -> SearchHitMapping.mappingFor(this.type, AbstractReactiveElasticsearchTemplate.this.converter).mapHit(response, entity));
        }
    }

    protected static interface SearchDocumentCallback<T> {
        public Mono<T> toEntity(SearchDocument var1);

        public Mono<SearchHit<T>> toSearchHit(SearchDocument var1);
    }

    public record IndexResponseMetaData(String id, String index, long seqNo, long primaryTerm, long version) {
    }

    protected class Entities<T> {
        private final List<T> entities;

        public Entities(List<T> entities) {
            Assert.notNull(entities, (String)"entities cannot be null");
            this.entities = entities;
        }

        public boolean isEmpty() {
            return this.entities.isEmpty();
        }

        public List<IndexQuery> indexQueries() {
            return this.entities.stream().map(AbstractReactiveElasticsearchTemplate.this::getIndexQuery).collect(Collectors.toList());
        }

        public T entityAt(long index) {
            int intIndex = (int)index;
            return this.entities.get(intIndex);
        }
    }

    protected class ReadDocumentCallback<T>
    implements DocumentCallback<T> {
        private final EntityReader<? super T, Document> reader;
        private final Class<T> type;
        private final IndexCoordinates index;

        public ReadDocumentCallback(EntityReader<? super T, Document> reader, Class<T> type, IndexCoordinates index) {
            Assert.notNull(reader, (String)"reader is null");
            Assert.notNull(type, (String)"type is null");
            this.reader = reader;
            this.type = type;
            this.index = index;
        }

        @Override
        @NonNull
        public Mono<T> toEntity(@Nullable Document document) {
            if (document == null) {
                return Mono.empty();
            }
            return AbstractReactiveElasticsearchTemplate.this.maybeCallbackAfterLoad(document, this.type, this.index).flatMap(documentAfterLoad -> {
                Object entity = this.reader.read(this.type, documentAfterLoad);
                IndexedObjectInformation indexedObjectInformation = new IndexedObjectInformation(documentAfterLoad.hasId() ? documentAfterLoad.getId() : null, documentAfterLoad.getIndex(), documentAfterLoad.hasSeqNo() ? Long.valueOf(documentAfterLoad.getSeqNo()) : null, documentAfterLoad.hasPrimaryTerm() ? Long.valueOf(documentAfterLoad.getPrimaryTerm()) : null, documentAfterLoad.hasVersion() ? Long.valueOf(documentAfterLoad.getVersion()) : null);
                entity = AbstractReactiveElasticsearchTemplate.this.entityOperations.updateIndexedObject(entity, indexedObjectInformation, AbstractReactiveElasticsearchTemplate.this.converter, AbstractReactiveElasticsearchTemplate.this.routingResolver);
                return AbstractReactiveElasticsearchTemplate.this.maybeCallbackAfterConvert(entity, (Document)documentAfterLoad, this.index);
            });
        }
    }

    protected static interface DocumentCallback<T> {
        @NonNull
        public Mono<T> toEntity(@Nullable Document var1);
    }
}

