/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query.highlight;

import org.springframework.data.elasticsearch.annotations.HighlightParameters;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightFieldParameters;
import org.springframework.util.Assert;

public class HighlightField {
    private final String name;
    private final HighlightFieldParameters parameters;

    public HighlightField(String name) {
        Assert.notNull((Object)name, (String)"name must not be null");
        this.name = name;
        this.parameters = HighlightFieldParameters.builder().build();
    }

    public HighlightField(String name, HighlightFieldParameters parameters) {
        Assert.notNull((Object)name, (String)"name must not be null");
        Assert.notNull((Object)parameters, (String)"parameters must not be null");
        this.name = name;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public HighlightFieldParameters getParameters() {
        return this.parameters;
    }

    public static HighlightField of(org.springframework.data.elasticsearch.annotations.HighlightField field) {
        HighlightParameters parameters = field.parameters();
        HighlightFieldParameters highlightParameters = ((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)((HighlightFieldParameters.HighlightFieldParametersBuilder)HighlightFieldParameters.builder().withBoundaryChars(parameters.boundaryChars())).withBoundaryMaxScan(parameters.boundaryMaxScan())).withBoundaryScanner(parameters.boundaryScanner())).withBoundaryScannerLocale(parameters.boundaryScannerLocale())).withForceSource(parameters.forceSource())).withFragmenter(parameters.fragmenter())).withFragmentOffset(parameters.fragmentOffset()).withFragmentSize(parameters.fragmentSize())).withMatchedFields(parameters.matchedFields()).withNoMatchSize(parameters.noMatchSize())).withNumberOfFragments(parameters.numberOfFragments())).withOrder(parameters.order())).withPhraseLimit(parameters.phraseLimit())).withPreTags(parameters.preTags())).withPostTags(parameters.postTags())).withRequireFieldMatch(parameters.requireFieldMatch())).withType(parameters.type())).build();
        return new HighlightField(field.name(), highlightParameters);
    }
}

