/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.join;

import java.util.Objects;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.lang.Nullable;

public class JoinField<ID> {
    private final String name;
    @Nullable
    private ID parent;

    public JoinField() {
        this("default", null);
    }

    public JoinField(String name) {
        this(name, null);
    }

    @PersistenceCreator
    public JoinField(String name, @Nullable ID parent) {
        this.name = name;
        this.parent = parent;
    }

    public void setParent(@Nullable ID parent) {
        this.parent = parent;
    }

    @Nullable
    public ID getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parent);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JoinField)) {
            return false;
        }
        JoinField other = (JoinField)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.parent, other.parent);
    }
}

