/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.lang.Nullable;

public interface BoundStreamOperations<K, HK, HV> {
    @Nullable
    public Long acknowledge(String var1, String ... var2);

    @Nullable
    public RecordId add(Map<HK, HV> var1);

    @Nullable
    public Long delete(String ... var1);

    @Nullable
    public String createGroup(ReadOffset var1, String var2);

    @Nullable
    public Boolean deleteConsumer(Consumer var1);

    @Nullable
    public Boolean destroyGroup(String var1);

    @Nullable
    public Long size();

    @Nullable
    default public List<MapRecord<K, HK, HV>> range(Range<String> range) {
        return this.range(range, RedisZSetCommands.Limit.unlimited());
    }

    @Nullable
    public List<MapRecord<K, HK, HV>> range(Range<String> var1, RedisZSetCommands.Limit var2);

    @Nullable
    default public List<MapRecord<K, HK, HV>> read(ReadOffset readOffset) {
        return this.read(StreamReadOptions.empty(), readOffset);
    }

    @Nullable
    public List<MapRecord<K, HK, HV>> read(StreamReadOptions var1, ReadOffset var2);

    @Nullable
    default public List<MapRecord<K, HK, HV>> read(Consumer consumer, ReadOffset readOffset) {
        return this.read(consumer, StreamReadOptions.empty(), readOffset);
    }

    @Nullable
    public List<MapRecord<K, HK, HV>> read(Consumer var1, StreamReadOptions var2, ReadOffset var3);

    @Nullable
    default public List<MapRecord<K, HK, HV>> reverseRange(Range<String> range) {
        return this.reverseRange(range, RedisZSetCommands.Limit.unlimited());
    }

    @Nullable
    public List<MapRecord<K, HK, HV>> reverseRange(Range<String> var1, RedisZSetCommands.Limit var2);

    @Nullable
    public Long trim(long var1);
}

