/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.rest.webmvc.json.patch.PatchException;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

class SpelPath {
    private static final SpelExpressionParser SPEL_EXPRESSION_PARSER = new SpelExpressionParser();
    private static final String APPEND_CHARACTER = "-";
    private static final Map<String, UntypedSpelPath> UNTYPED_PATHS = new ConcurrentReferenceHashMap(32);
    protected final String path;

    public static UntypedSpelPath untyped(String source) {
        return UNTYPED_PATHS.computeIfAbsent(source, x$0 -> new UntypedSpelPath((String)x$0));
    }

    public static TypedSpelPath typed(String source, Class<?> type) {
        return SpelPath.untyped(source).bindTo(type);
    }

    public boolean isAppend() {
        return this.path.endsWith(APPEND_CHARACTER);
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!SpelPath.class.isInstance(obj)) {
            return false;
        }
        SpelPath that = (SpelPath)obj;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private SpelPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    static class TypedSpelPath
    extends SpelPath {
        private static final String INVALID_PATH_REFERENCE = "Invalid path reference %s on type %s!";
        private static final String INVALID_COLLECTION_INDEX = "Invalid collection index %s for collection of size %s. Use '\u2026/-' or the collection's actual size as index to append to it!";
        private static final Map<CacheKey, TypedSpelPath> TYPED_PATHS = new ConcurrentReferenceHashMap(32);
        private static final EvaluationContext CONTEXT = SimpleEvaluationContext.forReadWriteDataBinding().build();
        private final Expression expression;
        private final Class<?> type;

        private TypedSpelPath(UntypedSpelPath path, Class<?> type) {
            super(path.path);
            this.type = type;
            this.expression = TypedSpelPath.toSpel(path.path, type);
        }

        public static TypedSpelPath of(UntypedSpelPath path, Class<?> type) {
            Assert.notNull((Object)path, (String)"Path must not be null!");
            Assert.notNull(type, (String)"Type must not be null!");
            return TYPED_PATHS.computeIfAbsent(CacheKey.of(type, path), key -> new TypedSpelPath(((CacheKey)key).path, ((CacheKey)key).type));
        }

        public <T> T getValue(Object target) {
            Assert.notNull((Object)target, (String)"Target must not be null!");
            try {
                return (T)this.expression.getValue(CONTEXT, target);
            }
            catch (ExpressionException o_O) {
                throw new PatchException("Unable to get value from target", (Exception)((Object)o_O));
            }
        }

        public void setValue(Object target, @Nullable Object value) {
            Assert.notNull((Object)target, (String)"Target must not be null!");
            this.expression.setValue(CONTEXT, target, value);
        }

        public Class<?> getLeafType() {
            return TypedSpelPath.verifyPath(this.path, this.type).map(PropertyPath::getLeafProperty).map(PropertyPath::getType).orElse(this.type);
        }

        public String getExpressionString() {
            return this.expression.getExpressionString();
        }

        public Class<?> getType(Object root) {
            Assert.notNull((Object)root, (String)"Root object must not be null!");
            try {
                return this.expression.getValueType(CONTEXT, root);
            }
            catch (SpelEvaluationException o_O) {
                if (!SpelMessage.COLLECTION_INDEX_OUT_OF_BOUNDS.equals((Object)o_O.getMessageCode())) {
                    throw o_O;
                }
                Object collectionOrArray = this.getParent().getValue(root);
                if (Collection.class.isInstance(collectionOrArray)) {
                    return CollectionUtils.findCommonElementType((Collection)((Collection)Collection.class.cast(collectionOrArray)));
                }
                throw new IllegalArgumentException(String.format("Cannot obtain type for path %s on %s!", this.path, root));
            }
        }

        public void copyFrom(UntypedSpelPath path, Object source) {
            Assert.notNull((Object)path, (String)"Source path must not be null!");
            Assert.notNull((Object)source, (String)"Source value must not be null!");
            this.addValue(source, path.bindTo(this.type).getValue(source));
        }

        public void moveFrom(UntypedSpelPath path, Object source) {
            Assert.notNull((Object)path, (String)"Source path must not be null!");
            Assert.notNull((Object)source, (String)"Source value must not be null!");
            this.addValue(source, path.bindTo(this.type).removeFrom(source));
        }

        public Object removeFrom(Object target) {
            Assert.notNull((Object)target, (String)"Target must not be null!");
            Integer listIndex = this.getTargetListIndex();
            Object value = this.getValue(target);
            if (listIndex == null) {
                try {
                    this.setValue(target, null);
                    return value;
                }
                catch (SpelEvaluationException o_O) {
                    throw new PatchException("Path '" + this.path + "' is not nullable.", (Exception)((Object)o_O));
                }
            }
            List list = (List)this.getParent().getValue(target);
            list.remove(listIndex >= 0 ? listIndex : list.size() - 1);
            return value;
        }

        public void addValue(Object target, Object value) {
            TypedSpelPath parentPath = this.getParent();
            Object parent = parentPath.getValue(target);
            Integer listIndex = this.getTargetListIndex();
            if (parent == null || !(parent instanceof List) || listIndex == null) {
                TypeDescriptor descriptor = parentPath.getTypeDescriptor(target);
                if (descriptor.isCollection() && !Collection.class.isInstance(value)) {
                    Collection collection = CollectionFactory.createCollection((Class)descriptor.getType(), (int)1);
                    collection.add(value);
                    parentPath.setValue(target, collection);
                } else {
                    this.setValue(target, value);
                }
            } else {
                List list = (List)parentPath.getValue(target);
                if (listIndex > list.size()) {
                    throw new PatchException(String.format(INVALID_COLLECTION_INDEX, listIndex, list.size()));
                }
                list.add(listIndex >= 0 ? listIndex.intValue() : list.size(), value);
            }
        }

        @Override
        public String toString() {
            return String.format("%s on %s -> %s", this.path, this.type.getName(), this.getExpressionString());
        }

        private TypedSpelPath getParent() {
            return SpelPath.untyped(this.path.substring(0, this.path.lastIndexOf(47))).bindTo(this.type);
        }

        private TypeDescriptor getTypeDescriptor(Object target) {
            return this.expression.getValueTypeDescriptor(CONTEXT, target);
        }

        private Integer getTargetListIndex() {
            String lastNode = this.path.substring(this.path.lastIndexOf(47) + 1);
            if (SpelPath.APPEND_CHARACTER.equals(lastNode)) {
                return -1;
            }
            try {
                return Integer.parseInt(lastNode);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        private static Optional<PropertyPath> verifyPath(String path, Class<?> type) {
            Assert.notNull((Object)path, (String)"Path must not be null!");
            Assert.notNull(type, (String)"Type must not be null!");
            String segmentSource = path.replaceAll("^/\\d+", "");
            Stream<String> segments = Arrays.stream(segmentSource.split("/")).filter(it -> !it.equals(SpelPath.APPEND_CHARACTER)).filter(it -> !it.isEmpty());
            try {
                return segments.reduce(Optional.empty(), (current, next) -> Optional.of(TypedSpelPath.createOrSkip(current, next, type)), (l, r) -> r).map(SkippedPropertyPath::getPath);
            }
            catch (PropertyReferenceException o_O) {
                throw new PatchException(String.format(INVALID_PATH_REFERENCE, o_O.getPropertyName(), type), (Exception)((Object)o_O));
            }
        }

        private static Expression toSpel(String path, Class<?> type) {
            String expression = Arrays.stream(path.split("/")).filter(it -> !it.isEmpty()).reduce(Optional.empty(), (current, next) -> Optional.of(TypedSpelPath.nextOrCreate(current, next, type)), (l, r) -> r).map(it -> it.getExpression()).orElse("#this");
            return SPEL_EXPRESSION_PARSER.parseExpression(expression);
        }

        private static SpelExpressionBuilder nextOrCreate(Optional<SpelExpressionBuilder> current, String next, Class<?> type) {
            return current.map(it -> it.next(next)).orElseGet(() -> SpelExpressionBuilder.of(type).next(next));
        }

        private static SkippedPropertyPath createOrSkip(Optional<SkippedPropertyPath> current, String next, Class<?> type) {
            return current.map(it -> it.nested(next)).orElseGet(() -> SkippedPropertyPath.of(next, type));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypedSpelPath)) {
                return false;
            }
            TypedSpelPath other = (TypedSpelPath)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Expression this$expression = this.expression;
            Expression other$expression = other.expression;
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            Class<?> this$type = this.type;
            Class<?> other$type = other.type;
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TypedSpelPath;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Expression $expression = this.expression;
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            Class<?> $type = this.type;
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        private static final class SpelExpressionBuilder {
            private static final TypeInformation<String> STRING_TYPE = ClassTypeInformation.from(String.class);
            @Nullable
            private final PropertyPath basePath;
            private final Class<?> type;
            private final String spelSegment;
            private final boolean skipped;

            public String getExpression() {
                return StringUtils.hasText((String)this.spelSegment) ? this.spelSegment : null;
            }

            public static SpelExpressionBuilder of(Class<?> type) {
                return new SpelExpressionBuilder(null, type, "", false);
            }

            private SpelExpressionBuilder skipWith(String segment) {
                return new SpelExpressionBuilder(this.basePath, this.type, this.spelSegment.concat(segment), true);
            }

            private SpelExpressionBuilder nested(String segment) {
                String segmentBase = StringUtils.hasText((String)this.spelSegment) ? this.spelSegment.concat(".") : this.spelSegment;
                try {
                    PropertyPath path = this.basePath == null ? PropertyPath.from((String)segment, this.type) : this.basePath.nested(segment);
                    return new SpelExpressionBuilder(path, this.type, segmentBase.concat(segment), false);
                }
                catch (PropertyReferenceException o_O) {
                    throw new PatchException(String.format(TypedSpelPath.INVALID_PATH_REFERENCE, o_O.getPropertyName(), this.type), (Exception)((Object)o_O));
                }
            }

            public SpelExpressionBuilder next(String segment) {
                if (this.basePath == null) {
                    if (SpelPath.APPEND_CHARACTER.equals(segment)) {
                        return this.skipWith("$[true]");
                    }
                    if (segment.matches("\\d+")) {
                        return this.skipWith(String.format("[%s]", segment));
                    }
                    return this.nested(segment);
                }
                if (this.skipped) {
                    return this.nested(segment);
                }
                TypeInformation typeInformation = this.basePath.getLeafProperty().getTypeInformation();
                if (typeInformation.isMap()) {
                    TypeInformation componentType = typeInformation.getComponentType();
                    String keyExpression = STRING_TYPE.equals((Object)componentType) ? String.format("'%s'", segment) : segment;
                    return this.skipWith(String.format("[%s]", keyExpression));
                }
                if (typeInformation.isCollectionLike()) {
                    return this.skipWith(SpelPath.APPEND_CHARACTER.equals(segment) ? "$[true]" : String.format("[%s]", segment));
                }
                return this.nested(segment);
            }

            public SpelExpressionBuilder(@Nullable PropertyPath basePath, Class<?> type, String spelSegment, boolean skipped) {
                this.basePath = basePath;
                this.type = type;
                this.spelSegment = spelSegment;
                this.skipped = skipped;
            }

            @Nullable
            public PropertyPath getBasePath() {
                return this.basePath;
            }

            public Class<?> getType() {
                return this.type;
            }

            public String getSpelSegment() {
                return this.spelSegment;
            }

            public boolean isSkipped() {
                return this.skipped;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SpelExpressionBuilder)) {
                    return false;
                }
                SpelExpressionBuilder other = (SpelExpressionBuilder)o;
                PropertyPath this$basePath = this.getBasePath();
                PropertyPath other$basePath = other.getBasePath();
                if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                    return false;
                }
                Class<?> this$type = this.getType();
                Class<?> other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$spelSegment = this.getSpelSegment();
                String other$spelSegment = other.getSpelSegment();
                if (this$spelSegment == null ? other$spelSegment != null : !this$spelSegment.equals(other$spelSegment)) {
                    return false;
                }
                return this.isSkipped() == other.isSkipped();
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                PropertyPath $basePath = this.getBasePath();
                result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
                Class<?> $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $spelSegment = this.getSpelSegment();
                result = result * 59 + ($spelSegment == null ? 43 : $spelSegment.hashCode());
                result = result * 59 + (this.isSkipped() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "SpelPath.TypedSpelPath.SpelExpressionBuilder(basePath=" + this.getBasePath() + ", type=" + this.getType() + ", spelSegment=" + this.getSpelSegment() + ", skipped=" + this.isSkipped() + ")";
            }
        }

        private static final class SkippedPropertyPath {
            private final PropertyPath path;
            private final boolean skipped;

            public static SkippedPropertyPath of(String segment, Class<?> type) {
                return SkippedPropertyPath.of(PropertyPath.from((String)segment, type), false);
            }

            public SkippedPropertyPath nested(String segment) {
                if (this.skipped) {
                    return SkippedPropertyPath.of(this.path.nested(segment), false);
                }
                TypeInformation typeInformation = this.path.getTypeInformation();
                return typeInformation.isMap() || typeInformation.isCollectionLike() ? SkippedPropertyPath.of(this.path, true) : SkippedPropertyPath.of(this.path.nested(segment), false);
            }

            public PropertyPath getPath() {
                return this.path;
            }

            public boolean isSkipped() {
                return this.skipped;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SkippedPropertyPath)) {
                    return false;
                }
                SkippedPropertyPath other = (SkippedPropertyPath)o;
                PropertyPath this$path = this.getPath();
                PropertyPath other$path = other.getPath();
                if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                    return false;
                }
                return this.isSkipped() == other.isSkipped();
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                PropertyPath $path = this.getPath();
                result = result * 59 + ($path == null ? 43 : $path.hashCode());
                result = result * 59 + (this.isSkipped() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "SpelPath.TypedSpelPath.SkippedPropertyPath(path=" + this.getPath() + ", skipped=" + this.isSkipped() + ")";
            }

            private SkippedPropertyPath(PropertyPath path, boolean skipped) {
                this.path = path;
                this.skipped = skipped;
            }

            private static SkippedPropertyPath of(PropertyPath path, boolean skipped) {
                return new SkippedPropertyPath(path, skipped);
            }
        }

        private static final class CacheKey {
            private final Class<?> type;
            private final UntypedSpelPath path;

            private CacheKey(Class<?> type, UntypedSpelPath path) {
                this.type = type;
                this.path = path;
            }

            public static CacheKey of(Class<?> type, UntypedSpelPath path) {
                return new CacheKey(type, path);
            }

            public Class<?> getType() {
                return this.type;
            }

            public UntypedSpelPath getPath() {
                return this.path;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)o;
                Class<?> this$type = this.getType();
                Class<?> other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                UntypedSpelPath this$path = this.getPath();
                UntypedSpelPath other$path = other.getPath();
                return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Class<?> $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                UntypedSpelPath $path = this.getPath();
                result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
                return result;
            }

            public String toString() {
                return "SpelPath.TypedSpelPath.CacheKey(type=" + this.getType() + ", path=" + this.getPath() + ")";
            }
        }
    }

    static class UntypedSpelPath
    extends SpelPath {
        private UntypedSpelPath(String path) {
            super(path);
        }

        public TypedSpelPath bindTo(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            return TypedSpelPath.of(this, type);
        }
    }
}

