/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.util.Collections;
import java.util.List;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.core.LinkBuilderSupport;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

public class RepositoryLinkBuilder
extends LinkBuilderSupport<RepositoryLinkBuilder> {
    private final ResourceMetadata metadata;

    public RepositoryLinkBuilder(ResourceMetadata metadata, BaseUri baseUri) {
        this(metadata, baseUri.getUriComponentsBuilder().path(metadata.getPath().toString()), Collections.emptyList());
    }

    private RepositoryLinkBuilder(ResourceMetadata metadata, UriComponentsBuilder builder, List<Affordance> affordances) {
        super(builder, affordances);
        Assert.notNull((Object)metadata, (String)"ResourceMetadata must not be null!");
        this.metadata = metadata;
    }

    public RepositoryLinkBuilder slash(Object object) {
        return PersistentProperty.class.isInstance(object) ? this.slash((PersistentProperty)object) : (RepositoryLinkBuilder)super.slash(object);
    }

    public RepositoryLinkBuilder slash(PersistentProperty<?> property) {
        return this.slash(this.metadata.getMappingFor(property).getPath());
    }

    public Link withResourceRel() {
        return this.withRel(this.metadata.getRel());
    }

    protected RepositoryLinkBuilder createNewInstance(UriComponentsBuilder builder, List<Affordance> affordances) {
        return new RepositoryLinkBuilder(this.metadata, builder, affordances);
    }

    protected RepositoryLinkBuilder getThis() {
        return this;
    }
}

