/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.Group;
import org.apache.solr.client.solrj.response.GroupCommand;
import org.apache.solr.client.solrj.response.GroupResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.client.solrj.response.TermsResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.repository.util.ClassUtils;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.core.SolrTemplate;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.PivotField;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.SimplePivotField;
import org.springframework.data.solr.core.query.result.FacetFieldEntry;
import org.springframework.data.solr.core.query.result.FacetPivotFieldEntry;
import org.springframework.data.solr.core.query.result.FacetQueryEntry;
import org.springframework.data.solr.core.query.result.FieldStatsResult;
import org.springframework.data.solr.core.query.result.GroupResult;
import org.springframework.data.solr.core.query.result.HighlightEntry;
import org.springframework.data.solr.core.query.result.SimpleFacetFieldEntry;
import org.springframework.data.solr.core.query.result.SimpleFacetPivotEntry;
import org.springframework.data.solr.core.query.result.SimpleFacetQueryEntry;
import org.springframework.data.solr.core.query.result.SimpleFieldStatsResult;
import org.springframework.data.solr.core.query.result.SimpleGroupEntry;
import org.springframework.data.solr.core.query.result.SimpleGroupResult;
import org.springframework.data.solr.core.query.result.SimpleStatsResult;
import org.springframework.data.solr.core.query.result.SimpleTermsFieldEntry;
import org.springframework.data.solr.core.query.result.SolrResultPage;
import org.springframework.data.solr.core.query.result.StatsResult;
import org.springframework.data.solr.core.query.result.TermsFieldEntry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class ResultHelper {
    private ResultHelper() {
    }

    static Map<String, List<TermsFieldEntry>> convertTermsQueryResponseToTermsMap(QueryResponse response) {
        if (response == null || response.getTermsResponse() == null || response.getTermsResponse().getTermMap() == null) {
            return Collections.emptyMap();
        }
        TermsResponse termsResponse = response.getTermsResponse();
        LinkedHashMap<String, List<TermsFieldEntry>> result = new LinkedHashMap<String, List<TermsFieldEntry>>(termsResponse.getTermMap().size());
        for (Map.Entry entry : termsResponse.getTermMap().entrySet()) {
            ArrayList<SimpleTermsFieldEntry> terms = new ArrayList<SimpleTermsFieldEntry>(((List)entry.getValue()).size());
            for (TermsResponse.Term term : (List)entry.getValue()) {
                SimpleTermsFieldEntry termsEntry = new SimpleTermsFieldEntry(term.getTerm(), term.getFrequency());
                termsEntry.setField((String)entry.getKey());
                terms.add(termsEntry);
            }
            result.put((String)entry.getKey(), (List<TermsFieldEntry>)terms);
        }
        return result;
    }

    static Map<Field, Page<FacetFieldEntry>> convertFacetQueryResponseToFacetPageMap(FacetQuery query, QueryResponse response) {
        Assert.notNull((Object)query, (String)"Cannot convert response for 'null', query");
        if (!ResultHelper.hasFacets(query, response)) {
            return Collections.emptyMap();
        }
        HashMap<Field, Page<FacetFieldEntry>> facetResult = new HashMap<Field, Page<FacetFieldEntry>>();
        if (!CollectionUtils.isEmpty((Collection)response.getFacetFields())) {
            int initalPageSize = Math.max(1, query.getFacetOptions().getPageable().getPageSize());
            for (FacetField facetField : response.getFacetFields()) {
                if (facetField == null || !StringUtils.hasText((String)facetField.getName())) continue;
                SimpleField field = new SimpleField(facetField.getName());
                if (CollectionUtils.isNotEmpty((Collection)facetField.getValues())) {
                    ArrayList<SimpleFacetFieldEntry> pageEntries = new ArrayList<SimpleFacetFieldEntry>(initalPageSize);
                    for (FacetField.Count count : facetField.getValues()) {
                        if (count == null) continue;
                        pageEntries.add(new SimpleFacetFieldEntry(field, count.getName(), count.getCount()));
                    }
                    facetResult.put(field, new SolrResultPage(pageEntries, query.getFacetOptions().getPageable(), facetField.getValueCount(), null));
                    continue;
                }
                facetResult.put(field, new SolrResultPage(Collections.emptyList(), query.getFacetOptions().getPageable(), 0L, null));
            }
        }
        return facetResult;
    }

    static Map<PivotField, List<FacetPivotFieldEntry>> convertFacetQueryResponseToFacetPivotMap(FacetQuery query, QueryResponse response) {
        if (VersionUtil.isSolr3XAvailable()) {
            return Collections.emptyMap();
        }
        HashMap<PivotField, List<FacetPivotFieldEntry>> facetResult = new HashMap<PivotField, List<FacetPivotFieldEntry>>();
        NamedList facetPivot = response.getFacetPivot();
        if (facetPivot != null && facetPivot.size() > 0) {
            for (int i = 0; i < facetPivot.size(); ++i) {
                String name = facetPivot.getName(i);
                List pivotResult = (List)facetPivot.get(name);
                facetResult.put(new SimplePivotField(name), ResultHelper.convertPivotResult(pivotResult));
            }
        }
        return facetResult;
    }

    private static List<FacetPivotFieldEntry> convertPivotResult(List<org.apache.solr.client.solrj.response.PivotField> pivotResult) {
        if (CollectionUtils.isEmpty(pivotResult)) {
            return Collections.emptyList();
        }
        ArrayList<FacetPivotFieldEntry> pivotFieldEntries = new ArrayList<FacetPivotFieldEntry>();
        for (org.apache.solr.client.solrj.response.PivotField pivotField : pivotResult) {
            SimpleFacetPivotEntry pivotFieldEntry = new SimpleFacetPivotEntry(new SimpleField(pivotField.getField()), String.valueOf(pivotField.getValue()), pivotField.getCount());
            List pivot = pivotField.getPivot();
            if (pivot != null) {
                pivotFieldEntry.setPivot(ResultHelper.convertPivotResult(pivot));
            }
            pivotFieldEntries.add(pivotFieldEntry);
        }
        return pivotFieldEntries;
    }

    static Map<Field, Page<FacetFieldEntry>> convertFacetQueryResponseToRangeFacetPageMap(FacetQuery query, QueryResponse response) {
        Assert.notNull((Object)query, (String)"Cannot convert response for 'null', query");
        if (!ResultHelper.hasFacets(query, response) || CollectionUtils.isEmpty((Collection)response.getFacetRanges())) {
            return Collections.emptyMap();
        }
        HashMap<Field, Page<FacetFieldEntry>> facetResult = new HashMap<Field, Page<FacetFieldEntry>>();
        Pageable pageable = query.getFacetOptions().getPageable();
        int initalPageSize = pageable.getPageSize();
        for (RangeFacet rangeFacet : response.getFacetRanges()) {
            long total;
            List entries;
            if (rangeFacet == null || !StringUtils.hasText((String)rangeFacet.getName())) continue;
            SimpleField field = new SimpleField(rangeFacet.getName());
            if (CollectionUtils.isNotEmpty((Collection)rangeFacet.getCounts())) {
                entries = new ArrayList(initalPageSize);
                for (RangeFacet.Count count : rangeFacet.getCounts()) {
                    entries.add(new SimpleFacetFieldEntry(field, count.getValue(), count.getCount()));
                }
                total = rangeFacet.getCounts().size();
            } else {
                entries = Collections.emptyList();
                total = 0L;
            }
            facetResult.put(field, new SolrResultPage(entries, pageable, total, null));
        }
        return facetResult;
    }

    static List<FacetQueryEntry> convertFacetQueryResponseToFacetQueryResult(FacetQuery query, QueryResponse response) {
        Assert.notNull((Object)query, (String)"Cannot convert response for 'null', query");
        if (!ResultHelper.hasFacets(query, response)) {
            return Collections.emptyList();
        }
        ArrayList<FacetQueryEntry> facetResult = new ArrayList<FacetQueryEntry>();
        if (MapUtils.isNotEmpty((Map)response.getFacetQuery())) {
            for (Map.Entry entry : response.getFacetQuery().entrySet()) {
                facetResult.add(new SimpleFacetQueryEntry((String)entry.getKey(), ((Integer)entry.getValue()).intValue()));
            }
        }
        return facetResult;
    }

    static <T> List<HighlightEntry<T>> convertAndAddHighlightQueryResponseToResultPage(QueryResponse response, SolrResultPage<T> page) {
        if (response == null || MapUtils.isEmpty((Map)response.getHighlighting()) || page == null) {
            return Collections.emptyList();
        }
        ArrayList mappedHighlights = new ArrayList(page.getSize());
        Map highlighting = response.getHighlighting();
        Iterator iterator = page.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            HighlightEntry highlightEntry = ResultHelper.processHighlightingForPageEntry(highlighting, item);
            mappedHighlights.add(highlightEntry);
        }
        page.setHighlighted(mappedHighlights);
        return mappedHighlights;
    }

    private static <T> HighlightEntry<T> processHighlightingForPageEntry(Map<String, Map<String, List<String>>> highlighting, T pageEntry) {
        HighlightEntry<T> highlightEntry = new HighlightEntry<T>(pageEntry);
        Object itemId = ResultHelper.getMappedId(pageEntry);
        Map<String, List<String>> highlights = highlighting.get(itemId.toString());
        if (MapUtils.isNotEmpty(highlights)) {
            for (Map.Entry<String, List<String>> entry : highlights.entrySet()) {
                highlightEntry.addSnipplets(entry.getKey(), entry.getValue());
            }
        }
        return highlightEntry;
    }

    private static Object getMappedId(Object o) {
        if (ClassUtils.hasProperty(o.getClass(), (String)"id")) {
            try {
                return FieldUtils.readDeclaredField((Object)o, (String)"id", (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new MappingException("Id property could not be accessed!", (Throwable)e);
            }
        }
        for (java.lang.reflect.Field field : o.getClass().getDeclaredFields()) {
            Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)field, Id.class);
            if (annotation == null) continue;
            try {
                return FieldUtils.readField((java.lang.reflect.Field)field, (Object)o, (boolean)true);
            }
            catch (IllegalArgumentException e) {
                throw new MappingException("Id property could not be accessed!", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MappingException("Id property could not be accessed!", (Throwable)e);
            }
        }
        throw new MappingException("Id property could not be found!");
    }

    private static boolean hasFacets(FacetQuery query, QueryResponse response) {
        return query.hasFacetOptions() && response != null;
    }

    static <T> Map<Object, GroupResult<T>> convertGroupQueryResponseToGroupResultMap(Query query, Map<String, Object> objectNames, QueryResponse response, SolrTemplate solrTemplate, Class<T> clazz) {
        GroupResponse groupResponse = response.getGroupResponse();
        if (groupResponse == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, GroupResult<T>> result = new LinkedHashMap<Object, GroupResult<T>>();
        List values = groupResponse.getValues();
        for (GroupCommand groupCommand : values) {
            ArrayList groupEntries = new ArrayList();
            for (Group group : groupCommand.getValues()) {
                SolrDocumentList documentList = group.getResult();
                List<T> beans = solrTemplate.convertSolrDocumentListToBeans(documentList, clazz);
                PageImpl page = new PageImpl(beans, query.getGroupOptions().getPageRequest(), documentList.getNumFound());
                groupEntries.add(new SimpleGroupEntry(group.getGroupValue(), page));
            }
            int matches = groupCommand.getMatches();
            Integer ngroups = groupCommand.getNGroups();
            String name = groupCommand.getName();
            PageImpl page = ngroups != null ? new PageImpl(groupEntries, query.getPageRequest(), (long)ngroups.intValue()) : new PageImpl(groupEntries);
            SimpleGroupResult groupResult = new SimpleGroupResult(matches, ngroups, name, page);
            result.put(name, groupResult);
            if (!objectNames.containsKey(name)) continue;
            result.put(objectNames.get(name), groupResult);
        }
        return result;
    }

    static Map<String, FieldStatsResult> convertFieldStatsInfoToFieldStatsResultMap(Map<String, FieldStatsInfo> fieldStatsInfo) {
        if (fieldStatsInfo == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, FieldStatsResult> result = new LinkedHashMap<String, FieldStatsResult>();
        for (Map.Entry<String, FieldStatsInfo> entry : fieldStatsInfo.entrySet()) {
            FieldStatsInfo value = entry.getValue();
            if (value == null) {
                result.put(entry.getKey(), new SimpleFieldStatsResult());
                continue;
            }
            SimpleFieldStatsResult statsResult = ResultHelper.populateStatsResultWithFieldStatsInfo(new SimpleFieldStatsResult(), value);
            statsResult.setCountDistinct(value.getCountDistinct());
            statsResult.setDistinctValues(value.getDistinctValues());
            Map facets = value.getFacets();
            if (facets != null) {
                statsResult.setStatsResults(ResultHelper.convertFieldStatsInfoToStatsResultMap(facets));
            }
            result.put(entry.getKey(), statsResult);
        }
        return result;
    }

    private static Map<String, Map<String, StatsResult>> convertFieldStatsInfoToStatsResultMap(Map<String, List<FieldStatsInfo>> statsInfo) {
        LinkedHashMap<String, Map<String, StatsResult>> result = new LinkedHashMap<String, Map<String, StatsResult>>();
        for (Map.Entry<String, List<FieldStatsInfo>> entry : statsInfo.entrySet()) {
            LinkedHashMap<String, SimpleStatsResult> facetStatsValues = new LinkedHashMap<String, SimpleStatsResult>();
            for (FieldStatsInfo fieldStatsInfo : entry.getValue()) {
                SimpleStatsResult statsResult = ResultHelper.populateStatsResultWithFieldStatsInfo(new SimpleStatsResult(), fieldStatsInfo);
                facetStatsValues.put(fieldStatsInfo.getName(), statsResult);
            }
            result.put(entry.getKey(), facetStatsValues);
        }
        return result;
    }

    private static <T extends SimpleStatsResult> T populateStatsResultWithFieldStatsInfo(T statsResult, FieldStatsInfo value) {
        Object sum;
        statsResult.setMax(value.getMax());
        statsResult.setMin(value.getMin());
        statsResult.setCount(value.getCount());
        statsResult.setMissing(value.getMissing());
        statsResult.setStddev(value.getStddev());
        statsResult.setSumOfSquares((Double)new DirectFieldAccessor((Object)value).getPropertyValue("sumOfSquares"));
        Object mean = value.getMean();
        if (mean instanceof Double) {
            statsResult.setMean((Double)mean);
        }
        if ((sum = value.getSum()) instanceof Double) {
            statsResult.setSum((Double)sum);
        }
        return statsResult;
    }
}

