/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.support;

import java.util.HashMap;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public final class MailUtils {
    private MailUtils() {
    }

    public static Map<String, Object> extractStandardHeaders(Message source) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        try {
            headers.put("mail_from", MailUtils.convertToString(source.getFrom()));
            headers.put("mail_bcc", MailUtils.convertToStringArray(source.getRecipients(Message.RecipientType.BCC)));
            headers.put("mail_cc", MailUtils.convertToStringArray(source.getRecipients(Message.RecipientType.CC)));
            headers.put("mail_to", MailUtils.convertToStringArray(source.getRecipients(Message.RecipientType.TO)));
            headers.put("mail_replyTo", MailUtils.convertToString(source.getReplyTo()));
            headers.put("mail_subject", source.getSubject());
            return headers;
        }
        catch (Exception e) {
            throw new MessagingException("conversion of MailMessage headers failed", (Throwable)e);
        }
    }

    private static String convertToString(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        Assert.state((addresses.length == 1 ? 1 : 0) != 0, (String)"expected a single value but received an Array");
        return addresses[0].toString();
    }

    private static String[] convertToStringArray(Address[] addresses) {
        if (addresses != null) {
            String[] addressStrings = new String[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                addressStrings[i] = addresses[i].toString();
            }
            return addressStrings;
        }
        return new String[0];
    }
}

