/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.util.Assert;

public class DelegatingByTypeSerializer
implements Serializer<Object> {
    private static final String RAWTYPES = "rawtypes";
    private final Map<Class<?>, Serializer> delegates = new HashMap();

    public DelegatingByTypeSerializer(Map<Class<?>, Serializer> delegates) {
        Assert.notNull(delegates, (String)"'delegates' cannot be null");
        Assert.noNullElements(delegates.values(), (String)"Serializers in delegates map cannot be null");
        this.delegates.putAll(delegates);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.delegates.values().forEach(del -> del.configure(configs, isKey));
    }

    public byte[] serialize(String topic, Object data) {
        Serializer delegate = this.findDelegate(data);
        return delegate.serialize(topic, data);
    }

    public byte[] serialize(String topic, Headers headers, Object data) {
        Serializer delegate = this.findDelegate(data);
        return delegate.serialize(topic, headers, data);
    }

    private Serializer findDelegate(Object data) {
        Serializer delegate = this.delegates.get(data.getClass());
        if (delegate == null) {
            throw new SerializationException("No matching delegate for type: " + data.getClass().getName() + "; supported types: " + this.delegates.keySet().stream().map(clazz -> clazz.getName()).collect(Collectors.toList()));
        }
        return delegate;
    }
}

