/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import io.netty.util.ReferenceCounted;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.PayloadUtils;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class DefaultRSocketRequester
implements RSocketRequester {
    private static final Map<String, Object> EMPTY_HINTS = Collections.emptyMap();
    private final RSocket rsocket;
    @Nullable
    private final MimeType dataMimeType;
    private final RSocketStrategies strategies;
    private DataBuffer emptyDataBuffer;

    DefaultRSocketRequester(RSocket rsocket, @Nullable MimeType dataMimeType, RSocketStrategies strategies) {
        Assert.notNull((Object)rsocket, (String)"RSocket is required");
        Assert.notNull((Object)strategies, (String)"RSocketStrategies is required");
        this.rsocket = rsocket;
        this.dataMimeType = dataMimeType;
        this.strategies = strategies;
        this.emptyDataBuffer = this.strategies.dataBufferFactory().wrap(new byte[0]);
    }

    @Override
    public RSocket rsocket() {
        return this.rsocket;
    }

    @Override
    public RSocketRequester.RequestSpec route(String route) {
        return new DefaultRequestSpec(route);
    }

    private static boolean isVoid(ResolvableType elementType) {
        return Void.class.equals((Object)elementType.resolve()) || Void.TYPE.equals(elementType.resolve());
    }

    private class DefaultResponseSpec
    implements RSocketRequester.ResponseSpec {
        @Nullable
        private final Mono<Payload> payloadMono;
        @Nullable
        private final Flux<Payload> payloadFlux;

        DefaultResponseSpec(Mono<Payload> payloadMono) {
            this.payloadMono = payloadMono;
            this.payloadFlux = null;
        }

        DefaultResponseSpec(Flux<Payload> payloadFlux) {
            this.payloadMono = null;
            this.payloadFlux = payloadFlux;
        }

        @Override
        public Mono<Void> send() {
            Assert.state((this.payloadMono != null ? 1 : 0) != 0, (String)"No RSocket interaction model for one-way send with Flux");
            return this.payloadMono.flatMap(arg_0 -> ((RSocket)DefaultRSocketRequester.this.rsocket).fireAndForget(arg_0));
        }

        @Override
        public <T> Mono<T> retrieveMono(Class<T> dataType) {
            return this.retrieveMono(ResolvableType.forClass(dataType));
        }

        @Override
        public <T> Mono<T> retrieveMono(ParameterizedTypeReference<T> dataTypeRef) {
            return this.retrieveMono(ResolvableType.forType(dataTypeRef));
        }

        @Override
        public <T> Flux<T> retrieveFlux(Class<T> dataType) {
            return this.retrieveFlux(ResolvableType.forClass(dataType));
        }

        @Override
        public <T> Flux<T> retrieveFlux(ParameterizedTypeReference<T> dataTypeRef) {
            return this.retrieveFlux(ResolvableType.forType(dataTypeRef));
        }

        private <T> Mono<T> retrieveMono(ResolvableType elementType) {
            Assert.notNull(this.payloadMono, (String)"No RSocket interaction model for Flux request to Mono response.");
            Mono payloadMono = this.payloadMono.flatMap(arg_0 -> ((RSocket)DefaultRSocketRequester.this.rsocket).requestResponse(arg_0));
            if (DefaultRSocketRequester.isVoid(elementType)) {
                return payloadMono.then();
            }
            Decoder decoder = DefaultRSocketRequester.this.strategies.decoder(elementType, DefaultRSocketRequester.this.dataMimeType);
            return payloadMono.map(this::retainDataAndReleasePayload).map(dataBuffer -> decoder.decode(dataBuffer, elementType, DefaultRSocketRequester.this.dataMimeType, EMPTY_HINTS));
        }

        private <T> Flux<T> retrieveFlux(ResolvableType elementType) {
            Flux payloadFlux;
            Flux flux = this.payloadMono != null ? this.payloadMono.flatMapMany(arg_0 -> ((RSocket)DefaultRSocketRequester.this.rsocket).requestStream(arg_0)) : (payloadFlux = DefaultRSocketRequester.this.rsocket.requestChannel(this.payloadFlux));
            if (DefaultRSocketRequester.isVoid(elementType)) {
                return payloadFlux.thenMany((Publisher)Flux.empty());
            }
            Decoder decoder = DefaultRSocketRequester.this.strategies.decoder(elementType, DefaultRSocketRequester.this.dataMimeType);
            return payloadFlux.map(this::retainDataAndReleasePayload).map(dataBuffer -> decoder.decode(dataBuffer, elementType, DefaultRSocketRequester.this.dataMimeType, EMPTY_HINTS));
        }

        private DataBuffer retainDataAndReleasePayload(Payload payload) {
            return PayloadUtils.retainDataAndReleasePayload(payload, DefaultRSocketRequester.this.strategies.dataBufferFactory());
        }
    }

    private class DefaultRequestSpec
    implements RSocketRequester.RequestSpec {
        private final String route;

        DefaultRequestSpec(String route) {
            this.route = route;
        }

        @Override
        public RSocketRequester.ResponseSpec data(Object data) {
            Assert.notNull((Object)data, (String)"'data' must not be null");
            return this.toResponseSpec(data, ResolvableType.NONE);
        }

        @Override
        public <T, P extends Publisher<T>> RSocketRequester.ResponseSpec data(P publisher, Class<T> dataType) {
            Assert.notNull(publisher, (String)"'publisher' must not be null");
            Assert.notNull(dataType, (String)"'dataType' must not be null");
            return this.toResponseSpec(publisher, ResolvableType.forClass(dataType));
        }

        @Override
        public <T, P extends Publisher<T>> RSocketRequester.ResponseSpec data(P publisher, ParameterizedTypeReference<T> dataTypeRef) {
            Assert.notNull(publisher, (String)"'publisher' must not be null");
            Assert.notNull(dataTypeRef, (String)"'dataTypeRef' must not be null");
            return this.toResponseSpec(publisher, ResolvableType.forType(dataTypeRef));
        }

        private RSocketRequester.ResponseSpec toResponseSpec(Object input, ResolvableType dataType) {
            Encoder encoder;
            Publisher publisher;
            ReactiveAdapter adapter = DefaultRSocketRequester.this.strategies.reactiveAdapterRegistry().getAdapter(input.getClass());
            if (input instanceof Publisher) {
                publisher = (Publisher)input;
            } else if (adapter != null) {
                publisher = adapter.toPublisher(input);
            } else {
                Mono payloadMono = Mono.fromCallable(() -> this.encodeValue(input, ResolvableType.forInstance((Object)input), null)).map(this::firstPayload).doOnDiscard(Payload.class, ReferenceCounted::release).switchIfEmpty(this.emptyPayload());
                return new DefaultResponseSpec((Mono<Payload>)payloadMono);
            }
            if (DefaultRSocketRequester.isVoid(dataType) || adapter != null && adapter.isNoValue()) {
                Mono payloadMono = Mono.when((Publisher[])new Publisher[]{publisher}).then(this.emptyPayload());
                return new DefaultResponseSpec((Mono<Payload>)payloadMono);
            }
            Encoder encoder2 = encoder = dataType != ResolvableType.NONE && !Object.class.equals((Object)dataType.resolve()) ? DefaultRSocketRequester.this.strategies.encoder(dataType, DefaultRSocketRequester.this.dataMimeType) : null;
            if (adapter != null && !adapter.isMultiValue()) {
                Mono payloadMono = Mono.from((Publisher)publisher).map(value -> this.encodeValue(value, dataType, encoder)).map(this::firstPayload).switchIfEmpty(this.emptyPayload());
                return new DefaultResponseSpec((Mono<Payload>)payloadMono);
            }
            Flux payloadFlux = Flux.from((Publisher)publisher).map(value -> this.encodeValue(value, dataType, encoder)).switchOnFirst((signal, inner) -> {
                DataBuffer data = (DataBuffer)signal.get();
                if (data != null) {
                    return Mono.fromCallable(() -> this.firstPayload(data)).concatWith((Publisher)inner.skip(1L).map(PayloadUtils::createPayload));
                }
                return inner.map(PayloadUtils::createPayload);
            }).doOnDiscard(Payload.class, ReferenceCounted::release).switchIfEmpty(this.emptyPayload());
            return new DefaultResponseSpec((Flux<Payload>)payloadFlux);
        }

        private <T> DataBuffer encodeValue(T value, ResolvableType valueType, @Nullable Encoder<?> encoder) {
            if (encoder == null) {
                encoder = DefaultRSocketRequester.this.strategies.encoder(ResolvableType.forInstance(value), DefaultRSocketRequester.this.dataMimeType);
            }
            return encoder.encodeValue(value, DefaultRSocketRequester.this.strategies.dataBufferFactory(), valueType, DefaultRSocketRequester.this.dataMimeType, EMPTY_HINTS);
        }

        private Payload firstPayload(DataBuffer data) {
            return PayloadUtils.createPayload(this.getMetadata(), data);
        }

        private Mono<Payload> emptyPayload() {
            return Mono.fromCallable(() -> this.firstPayload(DefaultRSocketRequester.this.emptyDataBuffer));
        }

        private DataBuffer getMetadata() {
            return DefaultRSocketRequester.this.strategies.dataBufferFactory().wrap(this.route.getBytes(StandardCharsets.UTF_8));
        }
    }
}

