/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ReflectionTestUtils {
    private static final Log logger = LogFactory.getLog((Class)ReflectionTestUtils.class);

    public static final void setField(Object target, String name, Object value, Class type) throws Exception {
        Field field;
        Assert.notNull((Object)target, (String)"The target object supplied to setField() can not be null.");
        Assert.hasText((String)name, (String)"The field name supplied to setField() can not be empty.");
        Assert.notNull((Object)type, (String)"The field type supplied to setField() can not be null.");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting field [" + name + "] on target [" + target + "] with value [" + value + "] and target type [" + type + "]."));
        }
        if ((field = ReflectionUtils.findField(target.getClass(), (String)name, (Class)type)) == null) {
            throw new IllegalArgumentException("Could not find field [" + name + "] on target [" + target + "] with type [" + type + "].");
        }
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)target, (Object)value);
    }

    public static final void invokeSetterMethod(Object target, String name, Object value, Class type) throws Exception {
        Method method;
        Assert.notNull((Object)target, (String)"The target object supplied to invokeSetterMethod() can not be null.");
        Assert.hasText((String)name, (String)"The method name supplied to invokeSetterMethod() can not be empty.");
        Assert.notNull((Object)type, (String)"The parameter type supplied to invokeSetterMethod() can not be null.");
        String setterMethodName = name;
        if (!setterMethodName.startsWith("set")) {
            setterMethodName = "set" + StringUtils.capitalize((String)setterMethodName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invoking setter method [" + setterMethodName + "] on target [" + target + "] with value [" + value + "] and parameter type [" + type + "]."));
        }
        if ((method = ReflectionUtils.findMethod(target.getClass(), (String)setterMethodName, (Class[])new Class[]{type})) == null) {
            throw new IllegalArgumentException("Could not find setter method [" + setterMethodName + "] on target [" + target + "] with parameter type [" + type + "].");
        }
        ReflectionUtils.makeAccessible((Method)method);
        ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])new Object[]{value});
    }
}

