/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.starter;

import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.tio.utils.hutool.ClassUtil;
import org.tio.websocket.starter.EnableTioWebSocketServer;

public class TioWebSocketClassScanner {
    private static final Logger logger = LoggerFactory.getLogger(TioWebSocketClassScanner.class);
    private ApplicationContext applicationContext;

    public TioWebSocketClassScanner(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void scanInstance(Class<?> beanClazz, Consumer<Object> consumer) {
        Map annotationMap = this.applicationContext.getBeansWithAnnotation(EnableTioWebSocketServer.class);
        Class<?> applicationClazz = annotationMap.entrySet().iterator().next().getValue().getClass();
        String packageName = applicationClazz.getPackage().getName();
        try {
            ClassUtil.scanPackage((String)packageName, clazz -> {
                if (!clazz.isInterface() && beanClazz.isAssignableFrom(clazz)) {
                    try {
                        consumer.accept(clazz.newInstance());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("create new instance of " + clazz.getTypeName() + " failed");
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        catch (NoClassDefFoundError error) {
            logger.warn("NoClassDefFoundError:" + error.getMessage());
        }
    }

    public void destroy() {
    }
}

