/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.starter;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.cluster.TioClusterConfig;
import org.tio.cluster.TioClusterTopic;
import org.tio.cluster.redisson.RedissonTioClusterTopic;
import org.tio.common.starter.TioServerMsgHandlerNotFoundException;
import org.tio.core.intf.GroupListener;
import org.tio.core.intf.TioUuid;
import org.tio.core.stat.IpStatListener;
import org.tio.server.ServerTioConfig;
import org.tio.server.intf.ServerAioListener;
import org.tio.utils.Threads;
import org.tio.websocket.server.WsServerAioListener;
import org.tio.websocket.server.WsServerConfig;
import org.tio.websocket.server.WsServerStarter;
import org.tio.websocket.server.handler.IWsMsgHandler;
import org.tio.websocket.starter.TioWebSocketClassScanner;
import org.tio.websocket.starter.TioWebSocketServerDefaultUuid;
import org.tio.websocket.starter.configuration.TioWebSocketServerClusterProperties;
import org.tio.websocket.starter.configuration.TioWebSocketServerProperties;
import org.tio.websocket.starter.configuration.TioWebSocketServerSslProperties;

public final class TioWebSocketServerBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(TioWebSocketServerBootstrap.class);
    private static final String GROUP_CONTEXT_NAME = "tio-websocket-spring-boot-starter";
    private boolean initialized = false;
    private TioWebSocketServerProperties serverProperties;
    private TioWebSocketServerClusterProperties clusterProperties;
    private TioWebSocketServerSslProperties serverSslProperties;
    private RedissonTioClusterTopic redissonTioClusterTopic;
    private WsServerConfig wsServerConfig;
    private TioClusterConfig clusterConfig;
    private WsServerStarter wsServerStarter;
    private ServerTioConfig serverTioConfig;
    private IWsMsgHandler tioWebSocketMsgHandler;
    private IpStatListener ipStatListener;
    private GroupListener groupListener;
    private WsServerAioListener serverAioListener;

    public TioWebSocketServerBootstrap(TioWebSocketServerProperties serverProperties, TioWebSocketServerClusterProperties clusterProperties, TioWebSocketServerSslProperties serverSslProperties, RedissonTioClusterTopic redissonTioClusterTopic, IWsMsgHandler tioWebSocketMsgHandler, IpStatListener ipStatListener, GroupListener groupListener, WsServerAioListener serverAioListener, TioWebSocketClassScanner tioWebSocketClassScanner) {
        this.serverProperties = serverProperties;
        this.clusterProperties = clusterProperties;
        this.serverSslProperties = serverSslProperties;
        logger.debug(serverSslProperties.toString());
        this.redissonTioClusterTopic = redissonTioClusterTopic;
        if (tioWebSocketClassScanner != null) {
            if (tioWebSocketMsgHandler == null) {
                tioWebSocketClassScanner.scanInstance(IWsMsgHandler.class, instance -> {
                    this.tioWebSocketMsgHandler = (IWsMsgHandler)instance;
                });
            } else {
                this.tioWebSocketMsgHandler = tioWebSocketMsgHandler;
            }
            if (ipStatListener == null) {
                tioWebSocketClassScanner.scanInstance(IpStatListener.class, instance -> {
                    this.ipStatListener = (IpStatListener)instance;
                });
            } else {
                this.ipStatListener = ipStatListener;
            }
            if (groupListener == null) {
                tioWebSocketClassScanner.scanInstance(GroupListener.class, instance -> {
                    this.groupListener = (GroupListener)instance;
                });
            } else {
                this.groupListener = groupListener;
            }
            if (serverAioListener == null) {
                tioWebSocketClassScanner.scanInstance(WsServerAioListener.class, instance -> {
                    this.serverAioListener = (WsServerAioListener)instance;
                });
            } else {
                this.serverAioListener = serverAioListener;
            }
        } else {
            this.tioWebSocketMsgHandler = tioWebSocketMsgHandler;
            this.ipStatListener = ipStatListener;
            this.groupListener = groupListener;
        }
        this.afterSetProperties(tioWebSocketClassScanner);
    }

    private void afterSetProperties(TioWebSocketClassScanner scanner) {
        if (this.tioWebSocketMsgHandler == null) {
            throw new TioServerMsgHandlerNotFoundException("no class implements IWsMsgHandler found");
        }
        if (this.ipStatListener == null) {
            logger.warn("no bean type of IpStatListener found");
        }
        if (this.groupListener == null) {
            logger.warn("no bean type of GroupListener found");
        }
        if (scanner != null) {
            scanner.destroy();
        }
    }

    public ServerTioConfig getServerTioConfig() {
        return this.serverTioConfig;
    }

    public void contextInitialized() {
        if (this.initialized) {
            logger.info("Tio WebSocket Server has been initialized");
            return;
        }
        logger.info("Initializing Tio WebSocket Server");
        try {
            this.initTioWebSocketConfig();
            this.initTioWebSocketServer();
            this.initTioWebSocketServerTioConfig();
            this.start();
            this.initialized = true;
        }
        catch (Throwable e) {
            logger.error("Cannot bootstrap tio websocket server :", e);
            throw new RuntimeException("Cannot bootstrap tio websocket server :", e);
        }
    }

    private void initTioWebSocketConfig() {
        this.wsServerConfig = new WsServerConfig(Integer.valueOf(this.serverProperties.getPort()));
        if (this.redissonTioClusterTopic != null && this.clusterProperties.isEnabled()) {
            this.clusterConfig = new TioClusterConfig((TioClusterTopic)this.redissonTioClusterTopic);
            this.clusterConfig.setCluster4all(this.clusterProperties.isAll());
            this.clusterConfig.setCluster4bsId(true);
            this.clusterConfig.setCluster4channelId(this.clusterProperties.isChannel());
            this.clusterConfig.setCluster4group(this.clusterProperties.isGroup());
            this.clusterConfig.setCluster4ip(this.clusterProperties.isIp());
            this.clusterConfig.setCluster4user(this.clusterProperties.isUser());
        }
    }

    private void initTioWebSocketServer() throws Exception {
        this.wsServerStarter = new WsServerStarter(this.wsServerConfig, this.tioWebSocketMsgHandler, (TioUuid)new TioWebSocketServerDefaultUuid(1L, 1L), Threads.getTioExecutor(), Threads.getGroupExecutor());
    }

    private void initTioWebSocketServerTioConfig() {
        this.serverTioConfig = this.wsServerStarter.getServerTioConfig();
        this.serverTioConfig.setName(GROUP_CONTEXT_NAME);
        if (this.ipStatListener != null) {
            this.serverTioConfig.setIpStatListener(this.ipStatListener);
            this.serverTioConfig.ipStats.addDurations(this.serverProperties.getIpStatDurations());
        }
        if (this.serverAioListener != null) {
            this.serverTioConfig.setServerAioListener((ServerAioListener)this.serverAioListener);
        }
        if (this.groupListener != null) {
            this.serverTioConfig.setGroupListener(this.groupListener);
        }
        if (this.serverProperties.getHeartbeatTimeout() > 0) {
            this.serverTioConfig.setHeartbeatTimeout((long)this.serverProperties.getHeartbeatTimeout());
        }
        if (this.clusterConfig != null) {
            this.serverTioConfig.setTioClusterConfig(this.clusterConfig);
        }
        if (this.serverSslProperties.isEnabled()) {
            try {
                this.serverTioConfig.useSsl(this.serverSslProperties.getKeyStore(), this.serverSslProperties.getTrustStore(), this.serverSslProperties.getPassword());
            }
            catch (Exception e) {
                logger.error("init ssl config error", (Throwable)e);
            }
        }
    }

    private void start() throws IOException {
        this.wsServerStarter.start();
    }
}

