/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.spi.ResourceBundleControlProvider;
import org.tentackle.common.BundleFactory;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.TentackleRuntimeException;

@Service(value=BundleFactory.class)
public class DefaultBundleFactory
implements BundleFactory {
    private final List<ResourceBundleControlProvider> providers = this.createProviders();
    private final Map<String, ResourceBundle.Control> controlMap = new ConcurrentHashMap<String, ResourceBundle.Control>();
    private ClassLoader classLoader;

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public final List<ResourceBundleControlProvider> getProviders() {
        return this.providers;
    }

    @Override
    public ResourceBundle.Control getControl(String baseName) {
        if (this.providers != null) {
            ResourceBundle.Control control = this.controlMap.get(baseName);
            if (control != null) {
                return control;
            }
            for (ResourceBundleControlProvider provider : this.providers) {
                control = provider.getControl(baseName);
                if (control == null) continue;
                this.controlMap.put(baseName, control);
                return control;
            }
        }
        return null;
    }

    @Override
    public ResourceBundle findBundle(String baseName) {
        ResourceBundle.Control control = this.getControl(baseName);
        if (this.classLoader == null) {
            return control == null ? ResourceBundle.getBundle(baseName) : ResourceBundle.getBundle(baseName, control);
        }
        return control == null ? ResourceBundle.getBundle(baseName, Locale.getDefault(), this.classLoader) : ResourceBundle.getBundle(baseName, Locale.getDefault(), this.classLoader, control);
    }

    @Override
    public ResourceBundle findBundle(String baseName, Locale locale) {
        ResourceBundle.Control control = this.getControl(baseName);
        if (this.classLoader == null) {
            return control == null ? ResourceBundle.getBundle(baseName, locale) : ResourceBundle.getBundle(baseName, locale, control);
        }
        return control == null ? ResourceBundle.getBundle(baseName, locale, this.classLoader) : ResourceBundle.getBundle(baseName, locale, this.classLoader, control);
    }

    @Override
    public ResourceBundle findBundle(String baseName, Locale locale, ClassLoader loader) {
        ResourceBundle.Control control = this.getControl(baseName);
        return control == null ? ResourceBundle.getBundle(baseName, locale, loader) : ResourceBundle.getBundle(baseName, locale, loader, control);
    }

    protected List<ResourceBundleControlProvider> createProviders() {
        ArrayList<ResourceBundleControlProvider> providerList = null;
        try {
            for (Class<ResourceBundleControlProvider> clazz : ServiceFactory.getServiceFinder().findServiceProviders(ResourceBundleControlProvider.class)) {
                if (providerList == null) {
                    providerList = new ArrayList<ResourceBundleControlProvider>();
                }
                providerList.add(clazz.newInstance());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new TentackleRuntimeException("cannot load bundle control providers", ex);
        }
        return providerList;
    }
}

