/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.function.Consumer;

public final class ExceptionHelper {
    public static <T extends Throwable> T extractException(Class<T> type, boolean first, Throwable headOfChain) {
        Throwable ex = null;
        while (headOfChain != null) {
            if (type.isAssignableFrom(headOfChain.getClass())) {
                ex = headOfChain;
                if (first) break;
            }
            headOfChain = headOfChain.getCause();
        }
        return (T)ex;
    }

    public static Throwable extractException(boolean first, Throwable headOfChain, Class<? extends Throwable> ... types) {
        Throwable ex = null;
        block0: while (headOfChain != null) {
            for (Class<? extends Throwable> type : types) {
                if (!type.isAssignableFrom(headOfChain.getClass())) continue;
                ex = headOfChain;
                if (!first) break;
                break block0;
            }
            headOfChain = headOfChain.getCause();
        }
        return ex;
    }

    public static boolean handleException(boolean first, Throwable headOfChain, Handler<? extends Throwable> ... handlers) {
        Throwable ex = null;
        Handler<? extends Throwable> found = null;
        block0: while (headOfChain != null) {
            for (Handler<? extends Throwable> handler : handlers) {
                if (!handler.appliesTo(headOfChain)) continue;
                found = handler;
                ex = headOfChain;
                if (!first) break;
                break block0;
            }
            headOfChain = headOfChain.getCause();
        }
        if (found != null) {
            found.handle(ex);
            return true;
        }
        return false;
    }

    public static String concatenateMessages(Throwable headOfChain) {
        StringBuilder buf = new StringBuilder();
        if (headOfChain != null) {
            if (headOfChain.getMessage() != null) {
                buf.append(headOfChain.getMessage());
            }
            for (Throwable cause = headOfChain.getCause(); cause != null; cause = cause.getCause()) {
                String subMsg = cause.getMessage();
                if (subMsg == null || buf.indexOf(subMsg) >= 0) continue;
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append(subMsg);
            }
        }
        return buf.toString();
    }

    public static String getStackTraceAsString(Throwable cause) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream(bs);){
            cause.printStackTrace(ps);
            ps.flush();
            String string = bs.toString();
            return string;
        }
    }

    private ExceptionHelper() {
    }

    public static class Handler<T extends Throwable> {
        private final Class<T> type;
        private final Consumer<T> consumer;

        public Handler(Class<T> type, Consumer<T> consumer) {
            this.type = type;
            this.consumer = consumer;
        }

        public boolean appliesTo(Throwable t) {
            return this.type.isAssignableFrom(t.getClass());
        }

        public void handle(T t) {
            this.consumer.accept(t);
        }
    }
}

